/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public final class FenceFastenerEntity
extends HangingEntity
implements IEntityAdditionalSpawnData {
    private int surfaceCheckTime;

    public FenceFastenerEntity(EntityType<? extends FenceFastenerEntity> type, Level world) {
        super(type, world);
    }

    public FenceFastenerEntity(Level world) {
        this((EntityType<? extends FenceFastenerEntity>)((EntityType)FLEntities.FASTENER.get()), world);
    }

    public FenceFastenerEntity(Level world, BlockPos pos) {
        this(world);
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public int m_7076_() {
        return 9;
    }

    public int m_7068_() {
        return 9;
    }

    public float m_6380_(Pose pose, EntityDimensions size) {
        return 1.0f;
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_7088_() {
        return !this.m_9236_().m_46749_(this.f_31698_) || ConnectionItem.isFence(this.m_9236_().m_8055_(this.f_31698_));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.getFastener().ifPresent(Fastener::remove);
        super.m_142687_(reason);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            this.m_5834_();
            this.m_5553_(source.m_7639_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_5553_(@Nullable Entity breaker) {
        this.getFastener().ifPresent(fastener -> fastener.dropItems(this.m_9236_(), this.f_31698_));
        if (breaker != null) {
            this.m_9236_().m_46796_(2001, this.f_31698_, Block.m_49956_((BlockState)((FastenerBlock)((Object)FLBlocks.FASTENER.get())).m_49966_()));
        }
    }

    public void m_7084_() {
        SoundType sound = ((FastenerBlock)((Object)FLBlocks.FASTENER.get())).getSoundType(((FastenerBlock)((Object)FLBlocks.FASTENER.get())).m_49966_(), (LevelReader)this.m_9236_(), this.m_31748_(), null);
        this.m_5496_(sound.m_56777_(), (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
    }

    public SoundSource m_5720_() {
        return SoundSource.BLOCKS;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, (double)Mth.m_14107_((double)y) + 0.5, (double)Mth.m_14107_((double)z) + 0.5);
    }

    public void m_6022_(Direction facing) {
    }

    protected void m_7087_() {
        double posX = (double)this.f_31698_.m_123341_() + 0.5;
        double posY = (double)this.f_31698_.m_123342_() + 0.5;
        double posZ = (double)this.f_31698_.m_123343_() + 0.5;
        this.m_20343_(posX, posY, posZ);
        float w = 0.1875f;
        float h = 0.1875f;
        this.m_20011_(new AABB(posX - 0.1875, posY - 0.1875, posZ - 0.1875, posX + 0.1875, posY + 0.1875, posZ + 0.1875));
    }

    public AABB m_6921_() {
        return this.getFastener().map(fastener -> fastener.getBounds().m_82400_(1.0)).orElseGet(() -> super.m_6921_());
    }

    public void m_8119_() {
        this.getFastener().ifPresent(fastener -> {
            if (!this.m_9236_().m_5776_() && (fastener.hasNoConnections() || this.checkSurface())) {
                this.m_5553_(null);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (fastener.update() && !this.m_9236_().m_5776_()) {
                UpdateEntityFastenerMessage msg = new UpdateEntityFastenerMessage((Entity)this, fastener.serializeNBT());
                ServerProxy.sendToPlayersWatchingEntity(msg, (Entity)this);
            }
        });
    }

    private boolean checkSurface() {
        if (this.surfaceCheckTime++ == 100) {
            this.surfaceCheckTime = 0;
            return !this.m_7088_();
        }
        return false;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ConnectionItem) {
            if (this.m_9236_().m_5776_()) {
                player.m_6674_(hand);
            } else {
                this.getFastener().ifPresent(fastener -> ((ConnectionItem)stack.m_41720_()).connect(stack, player, this.m_9236_(), (Fastener<?>)fastener));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.f_31698_));
    }

    public void m_7378_(CompoundTag compound) {
        this.f_31698_ = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("pos"));
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                NbtIo.m_128941_((CompoundTag)fastener.serializeNBT(), (DataOutput)new ByteBufOutputStream((ByteBuf)buf));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                fastener.deserializeNBT((Tag)NbtIo.m_128934_((DataInput)new ByteBufInputStream((ByteBuf)buf), (NbtAccounter)new NbtAccounter(0x200000L)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private LazyOptional<Fastener<?>> getFastener() {
        return this.getCapability(CapabilityHandler.FASTENER_CAP);
    }

    public static FenceFastenerEntity create(Level world, BlockPos fence) {
        FenceFastenerEntity fastener = new FenceFastenerEntity(world, fence);
        world.m_7967_((Entity)fastener);
        fastener.m_7084_();
        return fastener;
    }

    @Nullable
    public static FenceFastenerEntity find(Level world, BlockPos pos) {
        HangingEntity entity = FenceFastenerEntity.findHanging(world, pos);
        if (entity instanceof FenceFastenerEntity) {
            return (FenceFastenerEntity)entity;
        }
        return null;
    }

    @Nullable
    public static HangingEntity findHanging(Level world, BlockPos pos) {
        for (HangingEntity e : world.m_45976_(HangingEntity.class, new AABB(pos).m_82400_(2.0))) {
            if (!e.m_31748_().equals((Object)pos)) continue;
            return e;
        }
        return null;
    }
}

