/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.UUID;
import me.paulf.fairylights.server.collision.CollidableList;
import me.paulf.fairylights.server.collision.FeatureCollisionTree;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.HangingFeature;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class HangingFeatureConnection<F extends HangingFeature>
extends Connection {
    protected static final FeatureType FEATURE = FeatureType.register("feature");
    protected F[] features = this.createFeatures(0);

    public HangingFeatureConnection(ConnectionType<? extends HangingFeatureConnection<F>> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public final F[] getFeatures() {
        return this.features;
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateFeatures(relocated);
    }

    protected void updateFeatures(boolean relocated) {
        Curve catenary = this.getCatenary();
        float spacing = this.getFeatureSpacing();
        float totalLength = catenary.getLength();
        if (totalLength > 64.0f) {
            this.onBeforeUpdateFeatures();
            this.features = this.createFeatures(0);
            this.onAfterUpdateFeatures();
            return;
        }
        F[] prev = this.features;
        ArrayList features = new ArrayList();
        this.onBeforeUpdateFeatures();
        catenary.visitPoints(spacing, true, (index, x, y, z, yaw, pitch) -> {
            Object feature;
            if (!relocated && prev != null && index < prev.length && this.canReuse(prev[index], index)) {
                feature = prev[index];
                ((HangingFeature)feature).set(new Vec3((double)x, (double)y, (double)z), yaw, pitch);
            } else {
                feature = this.createFeature(index, new Vec3((double)x, (double)y, (double)z), yaw, pitch);
            }
            this.updateFeature(feature);
            features.add(feature);
        });
        this.features = features.toArray(this.createFeatures(features.size()));
        this.onAfterUpdateFeatures();
    }

    protected boolean canReuse(F feature, int index) {
        return true;
    }

    protected abstract F[] createFeatures(int var1);

    protected abstract F createFeature(int var1, Vec3 var2, float var3, float var4);

    protected abstract float getFeatureSpacing();

    protected void onBeforeUpdateFeatures() {
    }

    protected void updateFeature(F feature) {
    }

    protected void onAfterUpdateFeatures() {
    }

    @Override
    public void addCollision(CollidableList.Builder collision, Vec3 origin) {
        super.addCollision(collision, origin);
        if (this.features.length > 0) {
            MatrixStack matrix = new MatrixStack();
            collision.add(FeatureCollisionTree.build((FeatureType)FEATURE, this.features, f -> {
                Vec3[] verts;
                Vec3 pos = f.getPoint();
                double x = origin.f_82479_ + pos.f_82479_;
                double y = origin.f_82480_ + pos.f_82480_;
                double z = origin.f_82481_ + pos.f_82481_;
                matrix.push();
                if (f.parallelsCord()) {
                    matrix.rotate(-f.getYaw(), 0.0f, 1.0f, 0.0f);
                    matrix.rotate(f.getPitch(), 0.0f, 0.0f, 1.0f);
                }
                matrix.translate(0.0f, -f.getDescent(), 0.0f);
                AABBBuilder bounds = new AABBBuilder();
                AABB bb = f.getBounds().m_82400_(0.01);
                for (Vec3 vert : verts = new Vec3[]{new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82290_), new Vec3(bb.f_82291_, bb.f_82289_, bb.f_82290_), new Vec3(bb.f_82291_, bb.f_82289_, bb.f_82290_), new Vec3(bb.f_82288_, bb.f_82289_, bb.f_82293_), new Vec3(bb.f_82288_, bb.f_82292_, bb.f_82290_), new Vec3(bb.f_82291_, bb.f_82292_, bb.f_82290_), new Vec3(bb.f_82291_, bb.f_82292_, bb.f_82293_), new Vec3(bb.f_82288_, bb.f_82292_, bb.f_82293_)}) {
                    bounds.include(matrix.transform(vert));
                }
                matrix.pop();
                return bounds.add(x, y, z).build();
            }));
        }
    }
}

