/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BlockEntityRenderHelper {
    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer);
    }

    public static void renderBlockEntities(Level world, Iterable<BlockEntity> customRenderBEs, PoseStack ms, MultiBufferSource buffer, float pt) {
        BlockEntityRenderHelper.renderBlockEntities(world, null, customRenderBEs, ms, null, buffer, pt);
    }

    public static void renderBlockEntities(Level world, @Nullable VirtualRenderWorld renderWorld, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer) {
        BlockEntityRenderHelper.renderBlockEntities(world, renderWorld, customRenderBEs, ms, lightTransform, buffer, AnimationTickHolder.getPartialTicks());
    }

    public static void renderBlockEntities(Level realLevel, @Nullable VirtualRenderWorld renderLevel, Iterable<BlockEntity> customRenderBEs, PoseStack ms, @Nullable Matrix4f lightTransform, MultiBufferSource buffer, float pt) {
        if (renderLevel != null) {
            for (BlockEntity blockEntity : customRenderBEs) {
                blockEntity.m_142339_((Level)renderLevel);
            }
        }
        HashSet<BlockEntity> toRemove = new HashSet<BlockEntity>();
        for (BlockEntity blockEntity : customRenderBEs) {
            if (VisualizationManager.supportsVisualization((LevelAccessor)realLevel) && VisualizationHelper.skipVanillaRender((BlockEntity)blockEntity)) continue;
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(blockEntity);
            if (renderer == null) {
                toRemove.add(blockEntity);
                continue;
            }
            if (renderLevel == null && !renderer.m_142756_(blockEntity, Minecraft.m_91087_().f_91063_.m_109153_().m_90583_())) continue;
            BlockPos pos = blockEntity.m_58899_();
            ms.m_85836_();
            TransformStack.of((PoseStack)ms).translate((Vec3i)pos);
            try {
                int light;
                int realLevelLight = LevelRenderer.m_109541_((BlockAndTintGetter)realLevel, (BlockPos)BlockEntityRenderHelper.getLightPos(lightTransform, pos));
                if (renderLevel != null) {
                    renderLevel.setExternalLight(realLevelLight);
                    light = LevelRenderer.m_109541_((BlockAndTintGetter)renderLevel, (BlockPos)pos);
                } else {
                    light = realLevelLight;
                }
                renderer.m_6922_(blockEntity, pt, ms, buffer, light, OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                toRemove.add(blockEntity);
                String message = "BlockEntity " + CatnipServices.REGISTRIES.getKeyOrThrow(blockEntity.m_58903_()).toString() + " could not be rendered virtually.";
                if (((Boolean)AllConfigs.client().explainRenderErrors.get()).booleanValue()) {
                    Create.LOGGER.error(message, (Throwable)e);
                }
                Create.LOGGER.error(message);
            }
            ms.m_85849_();
        }
        if (renderLevel != null) {
            renderLevel.resetExternalLight();
            for (BlockEntity be : customRenderBEs) {
                be.m_142339_(realLevel);
            }
        }
        if (!toRemove.isEmpty()) {
            Iterator<BlockEntity> iterator = customRenderBEs.iterator();
            while (iterator.hasNext()) {
                if (!toRemove.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    private static BlockPos getLightPos(@Nullable Matrix4f lightTransform, BlockPos contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f((float)contraptionPos.m_123341_() + 0.5f, (float)contraptionPos.m_123342_() + 0.5f, (float)contraptionPos.m_123343_() + 0.5f, 1.0f);
            lightVec.mul((Matrix4fc)lightTransform);
            return BlockPos.m_274561_((double)lightVec.x(), (double)lightVec.y(), (double)lightVec.z());
        }
        return contraptionPos;
    }
}

