/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour;

import com.google.common.base.Suppliers;
import com.simibubi.create.api.contraption.storage.fluid.MountedFluidStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MovementContext {
    public Vec3 position;
    public Vec3 motion;
    public Vec3 relativeMotion;
    public UnaryOperator<Vec3> rotation;
    public Level world;
    public BlockState state;
    public BlockPos localPos;
    public CompoundTag blockEntityData;
    public boolean stall;
    public boolean disabled;
    public boolean firstMovement;
    public CompoundTag data;
    public Contraption contraption;
    public Object temporaryData;
    private FilterItemStack filter;
    private final Supplier<MountedItemStorage> itemStorage;
    private final Supplier<MountedFluidStorage> fluidStorage;

    public MovementContext(Level world, StructureTemplate.StructureBlockInfo info, Contraption contraption) {
        this.world = world;
        this.state = info.f_74676_();
        this.blockEntityData = info.f_74677_();
        this.contraption = contraption;
        this.localPos = info.f_74675_();
        this.disabled = false;
        this.firstMovement = true;
        this.motion = Vec3.f_82478_;
        this.relativeMotion = Vec3.f_82478_;
        this.rotation = v -> v;
        this.position = null;
        this.data = new CompoundTag();
        this.stall = false;
        this.filter = null;
        this.itemStorage = Suppliers.memoize(() -> (MountedItemStorage)contraption.getStorage().getAllItemStorages().get((Object)this.localPos));
        this.fluidStorage = Suppliers.memoize(() -> (MountedFluidStorage)contraption.getStorage().getFluids().storages.get((Object)this.localPos));
    }

    public float getAnimationSpeed() {
        int modifier = 1000;
        double length = -this.motion.m_82553_();
        if (this.disabled) {
            return 0.0f;
        }
        if (this.world.f_46443_ && this.contraption.stalled) {
            return 700.0f;
        }
        if (Math.abs(length) < 0.001953125) {
            return 0.0f;
        }
        return (int)(length * (double)modifier + 100.0 * Math.signum(length)) / 100 * 100;
    }

    public static MovementContext readNBT(Level world, StructureTemplate.StructureBlockInfo info, CompoundTag nbt, Contraption contraption) {
        MovementContext context = new MovementContext(world, info, contraption);
        context.motion = VecHelper.readNBT((ListTag)nbt.m_128437_("Motion", 6));
        context.relativeMotion = VecHelper.readNBT((ListTag)nbt.m_128437_("RelativeMotion", 6));
        if (nbt.m_128441_("Position")) {
            context.position = VecHelper.readNBT((ListTag)nbt.m_128437_("Position", 6));
        }
        context.stall = nbt.m_128471_("Stall");
        context.firstMovement = nbt.m_128471_("FirstMovement");
        context.data = nbt.m_128469_("Data");
        return context;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128365_("Motion", (Tag)VecHelper.writeNBT((Vec3)this.motion));
        nbt.m_128365_("RelativeMotion", (Tag)VecHelper.writeNBT((Vec3)this.relativeMotion));
        if (this.position != null) {
            nbt.m_128365_("Position", (Tag)VecHelper.writeNBT((Vec3)this.position));
        }
        nbt.m_128379_("Stall", this.stall);
        nbt.m_128379_("FirstMovement", this.firstMovement);
        nbt.m_128365_("Data", (Tag)this.data.m_6426_());
        return nbt;
    }

    public FilterItemStack getFilterFromBE() {
        if (this.filter != null) {
            return this.filter;
        }
        this.filter = FilterItemStack.of(this.blockEntityData.m_128469_("Filter"));
        return this.filter;
    }

    @Nullable
    public MountedItemStorage getItemStorage() {
        return this.itemStorage.get();
    }

    @Nullable
    public MountedFluidStorage getFluidStorage() {
        return this.fluidStorage.get();
    }
}

