/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class DynamicTree
extends AbstractBlockBreakQueue {
    private BlockPos startCutPos;

    public DynamicTree(BlockPos startCutPos) {
        this.startCutPos = startCutPos;
    }

    public static boolean isDynamicBranch(Block block) {
        return TreeHelper.isBranch((Block)block) || block instanceof TrunkShellBlock;
    }

    @Override
    public void destroyBlocks(Level world, ItemStack toDamage, @Nullable Player playerEntity, BiConsumer<BlockPos, ItemStack> drop) {
        BranchBlock start = TreeHelper.getBranch((BlockState)world.m_8055_(this.startCutPos));
        if (start == null) {
            start = this.setBranchToShellMuse(world, world.m_8055_(this.startCutPos));
        }
        if (start == null) {
            return;
        }
        world.m_5898_(null, 2001, this.startCutPos, Block.m_49956_((BlockState)world.m_8055_(this.startCutPos)));
        BranchDestructionData data = start.destroyBranchFromNode(world, this.startCutPos, Direction.DOWN, false, (LivingEntity)playerEntity);
        data.leavesDrops.forEach(stackPos -> drop.accept(stackPos.pos.m_121955_((Vec3i)this.startCutPos), stackPos.stack));
        start.getFamily().getCommonSpecies().getBranchesDrops(world, data.woodVolume).forEach(stack -> drop.accept(this.startCutPos, (ItemStack)stack));
    }

    private BranchBlock setBranchToShellMuse(Level world, BlockState state) {
        TrunkShellBlock.ShellMuse muse;
        Block block = state.m_60734_();
        if (block instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)block).getMuse((BlockGetter)world, this.startCutPos)) != null) {
            this.startCutPos = muse.pos;
            return TreeHelper.getBranch((BlockState)muse.state);
        }
        return null;
    }
}

