uniform sampler2D tex;
uniform vec2 resolution;
uniform float progress;

float gaussian(float y, float sigma) {
    return exp(-(y * y) / (2.0 * sigma * sigma));
}

void main() {
    vec2 uv = gl_FragCoord.xy / resolution;
    vec4 sum = vec4(0.0);
    float w = 0.0;
    for (float j = -10.0; j <= 10.0; j++) {
        float weight = gaussian(j, 10.0);
        sum += texture2D(tex, uv + vec2(0,j)/resolution) * weight;
        w += weight;
    }
    sum /= w;
    gl_FragColor = mix(texture2D(tex, uv), sum, progress);
}
