/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.utils;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.handlers.ConfigHandler;

@OnlyIn(value=Dist.CLIENT)
public class PhotoLoader
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String username;
    private final ConcurrentHashMap<String, NativeImage> skinImages;
    private final List<String> endUpload;

    public PhotoLoader(String username, ConcurrentHashMap<String, NativeImage> skinImages, List<String> endUpload) {
        this.username = username;
        this.skinImages = skinImages;
        this.endUpload = endUpload;
    }

    @Override
    public void run() {
        try {
            LOGGER.debug("=== Starting avatar load for: {} ===", (Object)this.username);
            NativeImage image = this.loadPlayerImage(this.username);
            if (image != null) {
                this.skinImages.put(this.username, image);
            } else {
                LOGGER.debug("\u274c FINAL: Failed to load avatar for: {}", (Object)this.username);
                this.skinImages.put(this.username, this.loadDefaultFace());
            }
            this.endUpload.add(this.username);
        }
        catch (Exception e) {
            LOGGER.error("\u274c FATAL: Error loading avatar for {}: {}", (Object)this.username, (Object)e.getMessage());
            try {
                this.skinImages.put(this.username, this.loadDefaultFace());
                this.endUpload.add(this.username);
            }
            catch (Exception ex) {
                LOGGER.error("\u274c CRITICAL: Failed to create placeholder for {}: {}", (Object)this.username, (Object)ex.getMessage());
            }
        }
    }

    private NativeImage loadPlayerImage(String username) {
        try {
            if (ConfigHandler.avatarUrl != null && !ConfigHandler.avatarUrl.isEmpty()) {
                String avatarUrl = ConfigHandler.avatarUrl.replace("%player%", username);
                NativeImage avatar = this.loadImageFromUrl(avatarUrl);
                if (avatar != null) {
                    return avatar;
                }
                LOGGER.debug("\u274c Failed to load avatar from: {}", (Object)avatarUrl);
            } else {
                LOGGER.debug("\u274c avatarUrl is null or empty in config");
            }
            if (ConfigHandler.skinUrl != null && !ConfigHandler.skinUrl.isEmpty()) {
                String skinUrl = ConfigHandler.skinUrl.replace("%player%", username);
                BufferedImage skin = this.loadBufferedImageFromUrl(skinUrl);
                if (skin != null) {
                    BufferedImage face = this.faceFromSkin(skin);
                    if (face != null) {
                        return this.convertToNativeImage(face);
                    }
                    LOGGER.debug("\u274c Failed to extract face from skin");
                } else {
                    LOGGER.debug("\u274c Failed to load skin from: {}", (Object)skinUrl);
                }
            } else {
                LOGGER.debug("\u274c skinUrl is null or empty in config");
            }
            LOGGER.debug("\u274c ALL methods failed for: {}", (Object)username);
            return null;
        }
        catch (Exception e) {
            LOGGER.error("\ud83d\udca5 Error loading avatar for {}: {}", (Object)username, (Object)e.getMessage());
            return null;
        }
    }

    private NativeImage loadImageFromUrl(String url) {
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "Minecraft Mod ChibiIsCute/1.0");
            InputStream stream = connection.getInputStream();
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            stream.close();
            return image;
        }
        catch (Exception e) {
            LOGGER.debug("\u274c Failed to load NativeImage from {}: {}", (Object)url, (Object)(e.getClass().getSimpleName() + ": " + e.getMessage()));
            return null;
        }
    }

    private BufferedImage loadBufferedImageFromUrl(String url) {
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("User-Agent", "Minecraft Mod ChibiIsCute/1.0");
            InputStream stream = connection.getInputStream();
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            return image;
        }
        catch (Exception e) {
            LOGGER.debug("\u274c Failed to load BufferedImage from {}: {}", (Object)url, (Object)(e.getClass().getSimpleName() + ": " + e.getMessage()));
            return null;
        }
    }

    private NativeImage convertToNativeImage(BufferedImage buffered) {
        try {
            NativeImage nativeImage = new NativeImage(buffered.getWidth(), buffered.getHeight(), false);
            for (int y = 0; y < buffered.getHeight(); ++y) {
                for (int x = 0; x < buffered.getWidth(); ++x) {
                    int argb = buffered.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int abgr = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.m_84988_(x, y, abgr);
                }
            }
            return nativeImage;
        }
        catch (Exception e) {
            LOGGER.error("Error converting BufferedImage to NativeImage: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage faceFromSkin(BufferedImage skinImage) {
        if (skinImage == null) {
            return null;
        }
        try {
            int BASE_SKIN_SIZE = 64;
            int BASE_FACE_SIZE = 8;
            if (skinImage.getWidth() < 64 || skinImage.getHeight() < 64) {
                LOGGER.debug("Skin too small for face extraction: {}x{}", (Object)skinImage.getWidth(), (Object)skinImage.getHeight());
                return null;
            }
            double scale = (double)skinImage.getHeight() / 64.0;
            int faceSize = (int)(8.0 * scale);
            BufferedImage face = skinImage.getSubimage(faceSize, faceSize, faceSize, faceSize);
            BufferedImage result = new BufferedImage(faceSize, faceSize, 2);
            Graphics2D g = result.createGraphics();
            try {
                g.drawImage((Image)face, 0, 0, null);
                if (skinImage.getWidth() >= 64) {
                    try {
                        BufferedImage overlay = skinImage.getSubimage(faceSize * 5, faceSize, faceSize, faceSize);
                        g.setComposite(AlphaComposite.SrcOver);
                        g.drawImage((Image)overlay, 0, 0, null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            finally {
                g.dispose();
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error extracting face from skin for {}: {}", (Object)this.username, (Object)e.getMessage());
            return null;
        }
    }

    private NativeImage loadDefaultFace() {
        NativeImage nativeImage;
        block17: {
            ResourceLocation defaultFace = new ResourceLocation("chibiiscute", "textures/gui/default_face.png");
            ResourceLocation fallbackFace = new ResourceLocation("textures/item/paper.png");
            InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(defaultFace).get()).m_215507_();
            try {
                nativeImage = NativeImage.m_85058_((InputStream)stream);
                if (stream == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    NativeImage nativeImage2;
                    block18: {
                        LOGGER.debug("Default face not found, using Minecraft fallback");
                        InputStream stream2 = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(fallbackFace).get()).m_215507_();
                        try {
                            nativeImage2 = NativeImage.m_85058_((InputStream)stream2);
                            if (stream2 == null) break block18;
                        }
                        catch (Throwable throwable3) {
                            try {
                                if (stream2 != null) {
                                    try {
                                        stream2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                            catch (Exception e2) {
                                LOGGER.error("Failed to load default face texture: {}", (Object)e2.getMessage());
                                return this.createColorPlaceholder(this.username);
                            }
                        }
                        stream2.close();
                    }
                    return nativeImage2;
                }
            }
            stream.close();
        }
        return nativeImage;
    }

    private NativeImage createColorPlaceholder(String username) {
        try {
            int hash = username.hashCode();
            int r = (hash & 0xFF0000) >> 16;
            int g = (hash & 0xFF00) >> 8;
            int b = hash & 0xFF;
            int color = 0xFF000000 | r << 16 | g << 8 | b;
            NativeImage image = new NativeImage(8, 8, false);
            for (int y = 0; y < 8; ++y) {
                for (int x = 0; x < 8; ++x) {
                    image.m_84988_(x, y, color);
                }
            }
            return image;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create color placeholder: {}", (Object)e.getMessage());
            return null;
        }
    }
}

