/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.render.font;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ModernGlyphCache {
    private static final int TEXTURE_SIZE = 4096;
    private Font font;
    private FontRenderContext fontRenderContext;
    private final Map<Integer, GlyphInfo> glyphCache = new HashMap<Integer, GlyphInfo>();
    private NativeImage textureImage;
    private DynamicTexture dynamicTexture;
    private ResourceLocation textureLocation;
    private int currentX = 1;
    private int currentY = 1;
    private int currentLineHeight = 0;
    private float fontHeight = 0.0f;

    public ModernGlyphCache() {
        this.initializeTexture();
        this.setupFontRenderContext();
    }

    public float getFontHeight() {
        return this.fontHeight;
    }

    public float getStringWidth(String text) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        return (float)this.font.getStringBounds(text, this.fontRenderContext).getWidth();
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    private GlyphInfo createGlyph(int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector glyphVector = this.font.layoutGlyphVector(this.fontRenderContext, chars, 0, chars.length, 0);
        Rectangle2D bounds = glyphVector.getVisualBounds();
        if (bounds.isEmpty()) {
            return null;
        }
        int width = (int)Math.ceil(bounds.getWidth());
        int height = (int)Math.ceil(bounds.getHeight());
        if (this.currentX + width + 1 > 4096) {
            this.currentX = 1;
            this.currentY += this.currentLineHeight + 1;
            this.currentLineHeight = 0;
        }
        if (this.currentY + height + 1 > 4096) {
            return null;
        }
        BufferedImage glyphImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = glyphImage.createGraphics();
        g2d.setColor(new Color(255, 255, 255, 0));
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.WHITE);
        g2d.drawGlyphVector(glyphVector, (float)(-bounds.getX()), (float)(-bounds.getY()));
        g2d.dispose();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = glyphImage.getRGB(x, y);
                this.textureImage.m_84988_(this.currentX + x, this.currentY + y, pixel);
            }
        }
        GlyphInfo glyphInfo = new GlyphInfo();
        glyphInfo.setTextureLocation(this.textureLocation);
        glyphInfo.u1 = (float)this.currentX / 4096.0f;
        glyphInfo.v1 = (float)this.currentY / 4096.0f;
        glyphInfo.u2 = (float)(this.currentX + width) / 4096.0f;
        glyphInfo.v2 = (float)(this.currentY + height) / 4096.0f;
        glyphInfo.width = width;
        glyphInfo.height = height;
        glyphInfo.advance = (float)bounds.getWidth();
        this.currentX += width + 1;
        if (height > this.currentLineHeight) {
            this.currentLineHeight = height;
        }
        this.dynamicTexture.m_117985_();
        return glyphInfo;
    }

    public float renderString(PoseStack poseStack, String text, float x, float y, int color, boolean shadow) {
        float advance = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            GlyphInfo glyph = this.getGlyph(c);
            if (glyph == null) continue;
            this.renderGlyph(poseStack, glyph, x + advance, y, color, shadow);
            advance += glyph.advance;
        }
        return advance;
    }

    private GlyphInfo getGlyph(char c) {
        return this.glyphCache.computeIfAbsent(Integer.valueOf(c), this::createGlyph);
    }

    private void renderGlyph(PoseStack poseStack, GlyphInfo glyph, float x, float y, int color, boolean shadow) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer buffer = bufferSource.m_6299_(glyph.renderType);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (shadow) {
            b = 0.0f;
            g = 0.0f;
            r = 0.0f;
            a *= 0.25f;
        }
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float x1 = x;
        float x2 = x + (float)glyph.width;
        float y1 = y;
        float y2 = y + (float)glyph.height;
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.u1, glyph.v1).m_5752_();
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.u1, glyph.v2).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.u2, glyph.v2).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_7421_(glyph.u2, glyph.v1).m_5752_();
        bufferSource.m_109911_();
    }

    private void calculateFontHeight() {
        GlyphVector vector = this.font.layoutGlyphVector(this.fontRenderContext, new char[]{'A', 'g', 'y'}, 0, 3, 0);
        Rectangle2D bounds = vector.getVisualBounds();
        this.fontHeight = (float)bounds.getHeight();
    }

    private void initializeTexture() {
        this.textureImage = new NativeImage(NativeImage.Format.RGBA, 4096, 4096, false);
        this.dynamicTexture = new DynamicTexture(this.textureImage);
        this.textureLocation = Minecraft.m_91087_().m_91097_().m_118490_("chibiiscute/glyph_cache", this.dynamicTexture);
    }

    private void setupFontRenderContext() {
        BufferedImage tempImage = new BufferedImage(1, 1, 2);
        Graphics2D g2d = tempImage.createGraphics();
        this.fontRenderContext = g2d.getFontRenderContext();
        g2d.dispose();
    }

    public void setDefaultFont(String name, int size, boolean antiAlias) {
        this.font = new Font(name, 0, size);
        this.font = this.font.deriveFont((float)size);
        this.updateFontMetrics();
    }

    public void setCustomFont(InputStream stream, int size, boolean antiAlias) throws Exception {
        this.font = Font.createFont(0, stream).deriveFont(0, size);
        this.updateFontMetrics();
    }

    public Font lookupFont(char[] text, int start, int limit, int style) {
        return this.font.deriveFont(style);
    }

    public void cacheGlyphs(Font font, char[] text, int start, int limit, int layoutFlags) {
        for (int i = start; i < limit; ++i) {
            char codePoint = text[i];
            if (this.glyphCache.containsKey(codePoint)) continue;
            this.createGlyph(font, codePoint);
        }
    }

    public GlyphInfo lookupGlyph(Font font, int glyphCode) {
        return this.glyphCache.get(glyphCode);
    }

    public GlyphVector layoutGlyphVector(Font font, char[] text, int start, int limit, int layoutFlags) {
        return font.layoutGlyphVector(this.fontRenderContext, text, start, limit, layoutFlags);
    }

    private void updateFontMetrics() {
        if (this.font == null) {
            return;
        }
        GlyphVector vector = this.font.layoutGlyphVector(this.fontRenderContext, "Agy".toCharArray(), 0, 3, 0);
        Rectangle2D bounds = vector.getVisualBounds();
        this.fontHeight = (float)bounds.getHeight();
    }

    private void createGlyph(Font font, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector glyphVector = font.layoutGlyphVector(this.fontRenderContext, chars, 0, chars.length, 0);
        Rectangle2D bounds = glyphVector.getVisualBounds();
        int width = (int)Math.ceil(bounds.getWidth());
        int height = (int)Math.ceil(bounds.getHeight());
        if (this.currentX + width + 1 > 4096) {
            this.currentX = 1;
            this.currentY += this.currentLineHeight + 1;
            this.currentLineHeight = 0;
        }
        if (this.currentY + height + 1 > 4096) {
            throw new RuntimeException("Glyph cache texture overflow");
        }
        BufferedImage glyphImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = glyphImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.drawGlyphVector(glyphVector, (float)(-bounds.getX()), (float)(-bounds.getY()));
        g2d.dispose();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = glyphImage.getRGB(x, y);
                this.textureImage.m_84988_(this.currentX + x, this.currentY + y, pixel);
            }
        }
        GlyphInfo glyph = new GlyphInfo();
        glyph.textureLocation = this.textureLocation;
        glyph.u1 = (float)this.currentX / 4096.0f;
        glyph.v1 = (float)this.currentY / 4096.0f;
        glyph.u2 = (float)(this.currentX + width) / 4096.0f;
        glyph.v2 = (float)(this.currentY + height) / 4096.0f;
        glyph.width = width;
        glyph.height = height;
        glyph.advance = (float)bounds.getWidth();
        this.glyphCache.put(codePoint, glyph);
        this.currentX += width + 1;
        if (height > this.currentLineHeight) {
            this.currentLineHeight = height;
        }
        this.dynamicTexture.m_117985_();
    }

    public static class GlyphInfo {
        public ResourceLocation textureLocation;
        public float u1;
        public float v1;
        public float u2;
        public float v2;
        public int width;
        public int height;
        public float advance;
        public RenderType renderType;

        public void setTextureLocation(ResourceLocation location) {
            this.textureLocation = location;
            this.renderType = RenderType.m_110497_((ResourceLocation)location);
        }
    }
}

