/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.gui.GuiCustomTab;

public class ConfigHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static String avatarUrl;
    public static String skinUrl;
    public static String tabHeader;
    public static boolean useGroupName;
    public static boolean useColouredBg;
    public static boolean useColorCodes;
    public static boolean drawTPS;
    public static boolean drawRoles;
    public static Map<String, String> roleColors;

    public static void init() {
        ConfigHandler.syncConfig();
    }

    public static void syncConfig() {
        try {
            avatarUrl = (String)ConfigHandler.COMMON.avatarUrl.get();
            skinUrl = (String)ConfigHandler.COMMON.skinUrl.get();
            tabHeader = (String)ConfigHandler.COMMON.tabHeader.get();
            useGroupName = (Boolean)ConfigHandler.COMMON.useGroupName.get();
            useColouredBg = (Boolean)ConfigHandler.COMMON.useColouredBg.get();
            useColorCodes = (Boolean)ConfigHandler.COMMON.useColorCodes.get();
            drawTPS = (Boolean)ConfigHandler.COMMON.drawTPS.get();
            drawRoles = (Boolean)ConfigHandler.COMMON.drawRoles.get();
            roleColors.clear();
            for (String entry : (List)ConfigHandler.COMMON.roleColorsList.get()) {
                String[] parts = entry.split(":", 2);
                if (parts.length != 2) continue;
                roleColors.put(parts[0], parts[1]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load config", (Throwable)e);
        }
    }

    public static void reloadConfig() {
        ConfigHandler.syncConfig();
    }

    public static String getColourByRole(String role) {
        return roleColors.getOrDefault(role, "#525252");
    }

    public static void updateClientConfig(String newTabHeader, String newAvatarUrl, String newSkinUrl, boolean newUseGroupName, boolean newUseColouredBg, boolean newUseColorCodes, boolean newDrawTPS, boolean newDrawRoles, List<String> newRoleColorsList) {
        tabHeader = newTabHeader;
        avatarUrl = newAvatarUrl;
        skinUrl = newSkinUrl;
        useGroupName = newUseGroupName;
        useColouredBg = newUseColouredBg;
        useColorCodes = newUseColorCodes;
        drawTPS = newDrawTPS;
        drawRoles = newDrawRoles;
        roleColors.clear();
        for (String entry : newRoleColorsList) {
            String[] parts = entry.split(":", 2);
            if (parts.length != 2) continue;
            roleColors.put(parts[0], parts[1]);
        }
        GuiCustomTab.updateTitle(tabHeader);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        roleColors = new HashMap<String, String>();
        roleColors.put("\u0418\u0433\u0440\u043e\u043a", "#525252");
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> avatarUrl;
        public final ForgeConfigSpec.ConfigValue<String> skinUrl;
        public final ForgeConfigSpec.ConfigValue<String> tabHeader;
        public final ForgeConfigSpec.BooleanValue useColouredBg;
        public final ForgeConfigSpec.BooleanValue useGroupName;
        public final ForgeConfigSpec.BooleanValue useColorCodes;
        public final ForgeConfigSpec.BooleanValue drawTPS;
        public final ForgeConfigSpec.BooleanValue drawRoles;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> roleColorsList;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Common settings").push("common");
            this.avatarUrl = builder.comment("URL for player avatars").define("avatarUrl", (Object)"https://example.com/avatars/%player%.png");
            this.skinUrl = builder.comment("URL for player skins").define("skinUrl", (Object)"https://chibicraft.ru/public/users/skins/%player%.png");
            this.tabHeader = builder.comment("Header text for tab list").define("tabHeader", (Object)"CHIBICRAFT | Project servers");
            this.useColouredBg = builder.comment("Use colored background in tab list").define("useColouredBg", false);
            this.useGroupName = builder.comment("Display group names in tab list").define("useGroupName", false);
            this.useColorCodes = builder.comment("Use color codes in text").define("useColorCodes", true);
            this.drawTPS = builder.comment("Display TPS in tab list").define("drawTPS", true);
            this.drawRoles = builder.comment("Display player roles in tab list").define("drawRoles", true);
            ArrayList<String> defaultRoleColors = new ArrayList<String>();
            defaultRoleColors.add("\u0418\u0433\u0440\u043e\u043a:#525252");
            this.roleColorsList = builder.comment("Role colors in format 'role:color'").defineList("roleColors", defaultRoleColors, entry -> entry instanceof String && ((String)entry).contains(":"));
            builder.pop();
        }
    }
}

