/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.chibicraft.chibiiscute.proxy.ResourcesProxy;
import ru.chibicraft.chibiiscute.render.PhotoRender;
import ru.chibicraft.chibiiscute.utils.MinecraftColorConverter;
import ru.chibicraft.chibiiscute.utils.PlayerInfoObj;

@OnlyIn(value=Dist.CLIENT)
public class GuiCustomTab
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static int playerPing;
    private static GuiCustomTab instance;
    private final Minecraft mc = Minecraft.m_91087_();
    public static final Map<String, PlayerInfoObj> playerList;
    public static volatile double currentTPS;
    private final List<String> onlinePlayers = Collections.synchronizedList(new ArrayList());
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 5000L;
    private static final int SCREEN_WIDTH_REFERENCE = 1920;
    private static final int SCREEN_HEIGHT_REFERENCE = 1080;
    private static final int CARD_WIDTH_BASE = 530;
    private static final int CARD_HEIGHT_BASE = 140;
    private static final int FONT_SIZE_BASE = 18;
    private static final int PADDING_BASE = 10;
    private static final int SPACING_BASE = 5;
    private static final int MAX_COLUMNS = 3;
    private static final int VISIBLE_ROWS = 5;
    private int scrollOffset = 0;
    private static String title;
    private static Component titleComponent;
    private boolean testDataInitialized = false;

    public GuiCustomTab() {
        super((Component)Component.m_237113_((String)"Custom Tab"));
        instance = this;
        this.updateOnlinePlayers();
    }

    public static GuiCustomTab getInstance() {
        return instance;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (System.currentTimeMillis() - this.lastUpdateTime > 5000L) {
            this.updateOnlinePlayers();
            this.lastUpdateTime = System.currentTimeMillis();
        }
        this.m_280273_(guiGraphics);
        double inverseScale = 1.0 / this.mc.m_91268_().m_85449_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_((float)inverseScale, (float)inverseScale, 1.0f);
        this.renderTexturedBackground(guiGraphics);
        this.renderPlayerList(guiGraphics);
        this.renderServerInfo(guiGraphics);
        guiGraphics.m_280168_().m_85849_();
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ArrayList<String> playersCopy;
        double guiScale = this.mc.m_91268_().m_85449_();
        int pixelMouseX = (int)(mouseX * guiScale);
        int pixelMouseY = (int)(mouseY * guiScale);
        int screenWidth = this.mc.m_91268_().m_85443_();
        int screenHeight = this.mc.m_91268_().m_85444_();
        int cardWidth = this.scaled(530);
        int cardHeight = this.scaled(140);
        int spacing = this.scaled(5);
        int columns = 3;
        int visibleRows = 5;
        int totalWidth = columns * cardWidth + (columns - 1) * spacing;
        int totalHeight = visibleRows * cardHeight + (visibleRows - 1) * spacing;
        int panelX = (screenWidth - totalWidth) / 2;
        int panelY = (screenHeight - totalHeight) / 2;
        List<String> list = this.onlinePlayers;
        synchronized (list) {
            playersCopy = new ArrayList<String>(this.onlinePlayers);
        }
        if (playersCopy.isEmpty()) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        int totalRows = (int)Math.ceil((double)playersCopy.size() / (double)columns);
        int maxOffset = Math.max(0, totalRows - visibleRows);
        int visibleStartRow = this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
        int visibleEndRow = Math.min(this.scrollOffset + visibleRows, totalRows);
        for (int row = visibleStartRow; row < visibleEndRow; ++row) {
            for (int col = 0; col < columns; ++col) {
                int playerIndex = row * columns + col;
                if (playerIndex >= playersCopy.size()) continue;
                String playerName = (String)playersCopy.get(playerIndex);
                int x = panelX + col * (cardWidth + spacing);
                int y = panelY + (row - this.scrollOffset) * (cardHeight + spacing);
                int buttonSize = this.scaled(50);
                int buttonX = x + cardWidth - buttonSize - this.scaled(5);
                int buttonY = y + this.scaled(5);
                if (pixelMouseX < buttonX || pixelMouseX > buttonX + buttonSize || pixelMouseY < buttonY || pixelMouseY > buttonY + buttonSize) continue;
                this.onPlayerCardButtonClicked(playerName);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int totalRows = (int)Math.ceil((double)this.onlinePlayers.size() / 3.0);
        int visibleRows = 5;
        if (delta > 0.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
        } else if (delta < 0.0) {
            int maxOffset = Math.max(0, totalRows - visibleRows);
            this.scrollOffset = Math.min(this.scrollOffset + 1, maxOffset);
        }
        return true;
    }

    private void onPlayerCardButtonClicked(String playerName) {
        this.sendTpCommand(playerName);
    }

    private void initializeTestData() {
        playerList.clear();
        this.onlinePlayers.clear();
        String[] roles = new String[]{"admin", "moderator", "vip", "builder", "media", "player"};
        String[] roleNames = new String[]{"&c\u0410\u0434\u043c\u0438\u043d", "&a\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", "&eVIP", "&b\u0421\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c", "&d\u041c\u0435\u0434\u0438\u0430", "&7\u0418\u0433\u0440\u043e\u043a"};
        int[] weights = new int[]{100, 80, 60, 40, 30, 10};
        for (int i = 1; i <= 50; ++i) {
            String playerName = "Player" + i;
            String role = roles[i % roles.length];
            String roleDisplayName = roleNames[i % roles.length];
            int weight = weights[i % weights.length] + i % 5;
            PlayerInfoObj playerInfo = new PlayerInfoObj();
            playerInfo.setUsername(playerName);
            playerInfo.setRole(role);
            playerInfo.setRoleDisplayName(roleDisplayName);
            playerInfo.setWeight(weight);
            playerList.put(playerName, playerInfo);
        }
        LOGGER.info("\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e {} \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432", (Object)playerList.size());
    }

    public static void updatePlayerData(Map<String, PlayerInfoObj> newPlayerData) {
        if (newPlayerData == null) {
            LOGGER.warn("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 null \u043a\u0430\u0440\u0442\u043e\u0439");
            return;
        }
        playerList.clear();
        playerList.putAll(newPlayerData);
        GuiCustomTab currentInstance = instance;
        if (currentInstance != null) {
            currentInstance.updateOnlinePlayers();
        }
    }

    public static void updateServerMetrics(double currentTPS2) {
        currentTPS = currentTPS2;
    }

    public static void updateTitle(String newTitle) {
        title = newTitle;
        titleComponent = MinecraftColorConverter.convertToComponent(newTitle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnlinePlayers() {
        List<String> list = this.onlinePlayers;
        synchronized (list) {
            this.onlinePlayers.clear();
            HashSet<String> playerNames = new HashSet<String>(playerList.keySet());
            for (String playerName : playerNames) {
                this.onlinePlayers.add(playerName);
                if (playerList.containsKey(playerName)) continue;
                PlayerInfoObj fallbackInfo = this.createFallbackPlayerInfo(playerName);
                playerList.put(playerName, fallbackInfo);
            }
            this.onlinePlayers.sort((player1, player2) -> {
                PlayerInfoObj info1 = playerList.get(player1);
                PlayerInfoObj info2 = playerList.get(player2);
                if (info1 == null || info2 == null) {
                    return 0;
                }
                return Integer.compare(info2.getWeight(), info1.getWeight());
            });
            this.scrollOffset = 0;
        }
    }

    private PlayerInfoObj createFallbackPlayerInfo(String username) {
        PlayerInfoObj playerInfo = new PlayerInfoObj();
        playerInfo.setUsername(username);
        if (username.equalsIgnoreCase(this.mc.m_91094_().m_92546_())) {
            playerInfo.setRole("admin");
            playerInfo.setRoleDisplayName("\u0410\u0434\u043c\u0438\u043d");
            playerInfo.setWeight(100);
        } else if (username.toLowerCase().contains("mod") || username.toLowerCase().contains("helper")) {
            playerInfo.setRole("moderator");
            playerInfo.setRoleDisplayName("\u041c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440");
            playerInfo.setWeight(50);
        } else if (username.length() <= 3) {
            playerInfo.setRole("vip");
            playerInfo.setRoleDisplayName("VIP");
            playerInfo.setWeight(30);
        } else {
            playerInfo.setRole("player");
            playerInfo.setRoleDisplayName("\u0418\u0433\u0440\u043e\u043a");
            playerInfo.setWeight(10);
        }
        return playerInfo;
    }

    private float getScreenScaleFactor() {
        int screenWidth = this.mc.m_91268_().m_85443_();
        int screenHeight = this.mc.m_91268_().m_85444_();
        float scaleX = (float)screenWidth / 1920.0f;
        float scaleY = (float)screenHeight / 1080.0f;
        return Math.min(scaleX, scaleY);
    }

    private float getFontScale() {
        return this.getScreenScaleFactor() * 3.0f;
    }

    private int scaled(int baseValue) {
        return Math.round((float)baseValue * this.getScreenScaleFactor());
    }

    private void renderTexturedBackground(GuiGraphics guiGraphics) {
        int screenWidth = this.mc.m_91268_().m_85443_();
        int screenHeight = this.mc.m_91268_().m_85444_();
        int panelWidth = this.scaled(1750);
        int panelHeight = this.scaled(880);
        panelWidth = Math.min(panelWidth, screenWidth - this.scaled(50));
        panelHeight = Math.min(panelHeight, screenHeight - this.scaled(50));
        int panelX = (screenWidth - panelWidth) / 2;
        int panelY = (screenHeight - panelHeight) / 2;
        guiGraphics.m_280163_(ResourcesProxy.getTexture(ResourcesProxy.BIG_WINDOW), panelX, panelY, 0.0f, 0.0f, panelWidth, panelHeight, panelWidth, panelHeight);
        float titleFontScale = this.getFontScale() * 1.3f;
        int titleWidth = (int)((float)this.mc.f_91062_.m_92852_((FormattedText)titleComponent) * titleFontScale);
        int titleX = panelX + (panelWidth - titleWidth) / 2;
        int titleY = panelY + this.scaled(18);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)titleX, (float)titleY, 0.0f);
        guiGraphics.m_280168_().m_85841_(titleFontScale, titleFontScale, 1.0f);
        guiGraphics.m_280614_(this.mc.f_91062_, titleComponent, 0, 0, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderServerInfo(GuiGraphics guiGraphics) {
        int onlineCount;
        int screenWidth = this.mc.m_91268_().m_85443_();
        int screenHeight = this.mc.m_91268_().m_85444_();
        int padding = this.scaled(10);
        int spacing = this.scaled(5);
        int cardWidth = this.scaled(530);
        int cardHeight = this.scaled(140);
        int columns = 3;
        int visibleRows = 5;
        int totalWidth = columns * cardWidth + (columns - 1) * spacing;
        int totalHeight = visibleRows * cardHeight + (visibleRows - 1) * spacing;
        int panelX = (screenWidth - totalWidth) / 2;
        int panelY = (screenHeight - totalHeight) / 2;
        List<String> list = this.onlinePlayers;
        synchronized (list) {
            onlineCount = this.onlinePlayers.size();
        }
        String serverInfoText = String.format("TPS: %.1f | \u041e\u043d\u043b\u0430\u0439\u043d: %d | \u041f\u0438\u043d\u0433: %d\u043c\u0441", currentTPS, onlineCount, playerPing > 0 ? playerPing : 0);
        int infoX = panelX + (totalWidth - (int)((float)this.mc.f_91062_.m_92895_(serverInfoText) * this.getFontScale())) / 2;
        int infoY = panelY + totalHeight + this.scaled(20);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)infoX, (float)infoY, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.getFontScale(), this.getFontScale(), 1.0f);
        guiGraphics.m_280056_(this.mc.f_91062_, serverInfoText, 0, 0, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPlayerList(GuiGraphics guiGraphics) {
        ArrayList<String> playersCopy;
        int screenWidth = this.mc.m_91268_().m_85443_();
        int screenHeight = this.mc.m_91268_().m_85444_();
        int cardWidth = this.scaled(530);
        int cardHeight = this.scaled(140);
        int spacing = this.scaled(5);
        int columns = 3;
        int visibleRows = 5;
        int totalWidth = columns * cardWidth + (columns - 1) * spacing;
        int totalHeight = visibleRows * cardHeight + (visibleRows - 1) * spacing;
        int panelX = (screenWidth - totalWidth) / 2;
        int panelY = (screenHeight - totalHeight) / 2;
        List<String> list = this.onlinePlayers;
        synchronized (list) {
            playersCopy = new ArrayList<String>(this.onlinePlayers);
        }
        if (playersCopy.isEmpty()) {
            return;
        }
        int totalRows = (int)Math.ceil((double)playersCopy.size() / (double)columns);
        int maxOffset = Math.max(0, totalRows - visibleRows);
        int visibleStartRow = this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
        int visibleEndRow = Math.min(this.scrollOffset + visibleRows, totalRows);
        for (int row = visibleStartRow; row < visibleEndRow; ++row) {
            for (int col = 0; col < columns; ++col) {
                int playerIndex = row * columns + col;
                if (playerIndex >= playersCopy.size()) continue;
                String playerName = (String)playersCopy.get(playerIndex);
                int x = panelX + col * (cardWidth + spacing);
                int y = panelY + (row - this.scrollOffset) * (cardHeight + spacing);
                this.renderPlayerCard(guiGraphics, playerName, x, y, cardWidth, cardHeight);
            }
        }
    }

    private void renderPlayerCard(GuiGraphics guiGraphics, String playerName, int x, int y, int width, int height) {
        int spacing = this.scaled(5);
        int avatarSize = Math.min(height - spacing, this.scaled(100));
        guiGraphics.m_280163_(ResourcesProxy.getTexture(ResourcesProxy.BUTTON_HOVER), x, y, 0.0f, 0.0f, width, height, width, height);
        int avatarX = x + spacing + this.scaled(15);
        int avatarY = y + (height - avatarSize) / 2;
        this.renderPlayerAvatar(guiGraphics, playerName, avatarX, avatarY, avatarSize, avatarSize);
        PlayerInfoObj playerInfo = playerList.get(playerName);
        String displayName = playerInfo != null ? playerInfo.getUsername() : playerName;
        Component nameComponent = MinecraftColorConverter.convertToComponent(displayName);
        int nameX = avatarX + avatarSize + spacing;
        String role = null;
        Component roleComponent = null;
        int roleHeight = 0;
        if (playerInfo != null && playerInfo.getRoleDisplayName() != null) {
            role = playerInfo.getRoleDisplayName();
            roleComponent = MinecraftColorConverter.convertToComponent(role);
            Objects.requireNonNull(this.mc.f_91062_);
            roleHeight = (int)(9.0f * this.getFontScale());
        }
        Objects.requireNonNull(this.mc.f_91062_);
        int nameHeight = (int)(9.0f * this.getFontScale());
        int lineHeight = nameHeight + this.scaled(4) + roleHeight;
        int textY = y + (height - lineHeight) / 2;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)nameX, (float)textY, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.getFontScale(), this.getFontScale(), 1.0f);
        guiGraphics.m_280614_(this.mc.f_91062_, nameComponent, 0, 0, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
        if (roleComponent != null) {
            int roleY = textY + nameHeight + this.scaled(4);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)nameX, (float)roleY, 0.0f);
            guiGraphics.m_280168_().m_85841_(this.getFontScale(), this.getFontScale(), 1.0f);
            guiGraphics.m_280614_(this.mc.f_91062_, roleComponent, 0, 0, 0xAAAAAA, false);
            guiGraphics.m_280168_().m_85849_();
        }
        int buttonSize = this.scaled(50);
        int buttonX = x + width - buttonSize - this.scaled(5);
        int buttonY = y + this.scaled(5);
        guiGraphics.m_280163_(ResourcesProxy.getTexture(ResourcesProxy.BUTTON_TP), buttonX, buttonY, 0.0f, 0.0f, buttonSize, buttonSize, buttonSize, buttonSize);
    }

    private void renderPlayerAvatar(GuiGraphics guiGraphics, String playerName, int x, int y, int width, int height) {
        try {
            PhotoRender.getInstance().drawAvatar(guiGraphics, playerName, x, y, width, height, 1.0f);
        }
        catch (Exception e) {
            guiGraphics.m_280509_(x, y, x + width, y + height, -10066330);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(x + width / 2 - 2), (float)(y + height / 2 - 4), 0.0f);
            guiGraphics.m_280168_().m_85841_(this.getFontScale(), this.getFontScale(), 1.0f);
            guiGraphics.m_280056_(this.mc.f_91062_, "?", 0, 0, 0xFFFFFF, false);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void sendTpCommand(String playerName) {
        boolean hasOp = this.mc.f_91074_ != null && this.mc.f_91074_.m_20310_(2);
        String command = hasOp ? "tp " + playerName : "tpa " + playerName;
        this.mc.f_91074_.f_108617_.m_246623_(command);
    }

    private int getTpsColor(double tps) {
        if (tps >= 18.0) {
            return -16711936;
        }
        if (tps >= 15.0) {
            return -256;
        }
        return -65536;
    }

    private int getMsptColor(double mspt) {
        if (mspt <= 40.0) {
            return -16711936;
        }
        if (mspt <= 50.0) {
            return -256;
        }
        return -65536;
    }

    private int getPingColor(int ping) {
        if (ping <= 100) {
            return -16711936;
        }
        if (ping <= 200) {
            return -256;
        }
        return -65536;
    }

    private int getRoleColor(String role) {
        return switch (role.toLowerCase()) {
            case "admin", "owner", "administrator" -> -65536;
            case "vip", "premium", "donator" -> -256;
            case "moderator", "mod", "helper" -> -16711936;
            case "builder", "media" -> -16711681;
            default -> -7829368;
        };
    }

    public static void updatePing(int newPing) {
        playerPing = newPing;
    }

    public void refreshPlayerList() {
        this.updateOnlinePlayers();
    }

    public boolean m_7043_() {
        return false;
    }

    static {
        playerList = new ConcurrentHashMap<String, PlayerInfoObj>();
        currentTPS = 0.0;
        title = "Custom Tab";
        titleComponent = Component.m_237113_((String)"Custom Tab");
    }
}

