/*
 * Decompiled with CFR 0.152.
 */
package ru.chibicraft.chibiiscute.bukkit;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.group.GroupManager;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import ru.chibicraft.chibiiscute.ChibiIsCute;
import ru.chibicraft.chibiiscute.utils.PlayerInfoObj;

@Mod.EventBusSubscriber(modid="chibiiscute", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FileLuckPermsHelper {
    private static boolean isLuckPermsAvailable = false;
    private static boolean isBukkitAvailable = false;
    private static boolean isInitialised = false;
    private static Object providerLuckPerms = null;
    private static UserManager lpUserManager = null;
    private static GroupManager lpGroupManager = null;

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static Map<String, PlayerInfoObj> getPlayers() {
        if (!isInitialised) {
            FileLuckPermsHelper.checkBukkitAvailability();
            FileLuckPermsHelper.getProviders();
            isInitialised = true;
        }
        HashMap<String, PlayerInfoObj> players = new HashMap<String, PlayerInfoObj>();
        if (!isLuckPermsAvailable || lpUserManager == null || lpGroupManager == null) {
            ChibiIsCute.LOGGER.warn("LuckPerms \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0438\u043b\u0438 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
            return players;
        }
        try {
            Collection onlinePlayers = Bukkit.getOnlinePlayers();
            for (Player player : onlinePlayers) {
                try {
                    User user = lpUserManager.getUser(player.getUniqueId());
                    if (user == null) {
                        ChibiIsCute.LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f LuckPerms \u0434\u043b\u044f: {}", (Object)player.getName());
                        continue;
                    }
                    String role = user.getCachedData().getMetaData().getPrimaryGroup();
                    String roleDisplayName = user.getCachedData().getMetaData().getPrefix();
                    String username = user.getUsername();
                    int weight = 10;
                    try {
                        String weightValue;
                        Group group;
                        String primaryGroup = user.getPrimaryGroup();
                        if (primaryGroup != null && (group = lpGroupManager.getGroup(primaryGroup)) != null && (weightValue = group.getCachedData().getMetaData().getMetaValue("weight")) != null && !weightValue.isEmpty()) {
                            weight = Integer.parseInt(weightValue);
                        }
                    }
                    catch (NumberFormatException e) {
                        ChibiIsCute.LOGGER.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0430\u0440\u0441\u0438\u0442\u044c \u0432\u0435\u0441 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f\u044b \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)username, (Object)e.getMessage());
                    }
                    catch (Exception e) {
                        ChibiIsCute.LOGGER.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0435\u0441\u0430 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)username, (Object)e.getMessage());
                    }
                    if (username == null || username.isEmpty()) {
                        username = player.getName();
                    }
                    if (roleDisplayName == null) {
                        roleDisplayName = "";
                    }
                    if (role == null || role.isEmpty()) {
                        role = "default";
                    }
                    PlayerInfoObj playerInfoObj_item = new PlayerInfoObj(role, roleDisplayName, username, weight);
                    players.put(username, playerInfoObj_item);
                }
                catch (Exception e) {
                    ChibiIsCute.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0438\u0433\u0440\u043e\u043a\u0430 {}: {}", (Object)player.getName(), (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            ChibiIsCute.LOGGER.error("\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u0438\u0433\u0440\u043e\u043a\u043e\u0432: {}", (Object)e.getMessage(), (Object)e);
        }
        return players;
    }

    private static void checkBukkitAvailability() {
        try {
            Class.forName("org.bukkit.Bukkit");
            isBukkitAvailable = true;
            ChibiIsCute.LOGGER.info("org.bukkit.Bukkit \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u043c\u043e\u0434\u0443");
        }
        catch (ClassNotFoundException e) {
            isBukkitAvailable = false;
            ChibiIsCute.LOGGER.error("org.bukkit.Bukkit \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
        }
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static void getProviders() {
        block11: {
            try {
                Plugin[] plugins;
                for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
                    List providers = Bukkit.getServicesManager().getRegistrations(plugin);
                    for (RegisteredServiceProvider provider : providers) {
                        if (!"net.luckperms.api.LuckPerms".equals(provider.getService().getName())) continue;
                        providerLuckPerms = provider.getProvider();
                    }
                }
                if (providerLuckPerms != null) {
                    try {
                        Method getUserManagerMethod = providerLuckPerms.getClass().getMethod("getUserManager", new Class[0]);
                        lpUserManager = (UserManager)getUserManagerMethod.invoke(providerLuckPerms, new Object[0]);
                    }
                    catch (Exception e) {
                        ChibiIsCute.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 getUserManager(): {}", (Object)e.getMessage(), (Object)e);
                    }
                    ChibiIsCute.LOGGER.info("=======");
                    try {
                        Method getGroupManagerMethod = providerLuckPerms.getClass().getMethod("getGroupManager", new Class[0]);
                        lpGroupManager = (GroupManager)getGroupManagerMethod.invoke(providerLuckPerms, new Object[0]);
                    }
                    catch (Exception e) {
                        ChibiIsCute.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 getGroupManager(): {}", (Object)e.getMessage(), (Object)e);
                    }
                    if (lpUserManager != null && lpGroupManager != null) {
                        isLuckPermsAvailable = true;
                        ChibiIsCute.LOGGER.info("LuckPerms \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
                    } else {
                        ChibiIsCute.LOGGER.warn("LuckPerms \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u044b");
                    }
                    break block11;
                }
                ChibiIsCute.LOGGER.warn("LuckPerms \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            catch (Exception e) {
                ChibiIsCute.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 getProvidersInfo() : {}", (Object)e.getMessage());
            }
        }
    }
}

