/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.zergatul.cheatutils.webui.HttpHelper;
import com.zergatul.cheatutils.wrappers.ModEnvironment;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;

public class StaticFilesHandler
implements HttpHandler {
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        byte[] bytes;
        String filename = exchange.getRequestURI().getPath().equals("/") ? "/index.html" : exchange.getRequestURI().getPath();
        InputStream stream = ModEnvironment.isProduction ? StaticFilesHandler.loadFromResource("web" + filename) : StaticFilesHandler.loadFromFile("web" + filename);
        try (InputStream inputStream = stream;){
            if (stream == null) {
                exchange.sendResponseHeaders(404, 0L);
                exchange.close();
                return;
            }
            bytes = IOUtils.toByteArray((InputStream)stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            exchange.sendResponseHeaders(503, 0L);
            exchange.close();
            return;
        }
        HttpHelper.setContentType(exchange, filename);
        exchange.sendResponseHeaders(200, bytes.length);
        OutputStream os = exchange.getResponseBody();
        os.write(bytes);
        os.close();
        exchange.close();
    }

    private static InputStream loadFromResource(String filename) {
        ClassLoader classLoader = StaticFilesHandler.class.getClassLoader();
        return classLoader.getResourceAsStream(filename);
    }

    private static InputStream loadFromFile(String filename) {
        try {
            Path path = Paths.get(System.getProperty("user.dir"), "../src/main/resources", filename);
            return new FileInputStream(path.toString());
        }
        catch (IOException e) {
            return null;
        }
    }
}

