/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ValidatableConfig;
import com.zergatul.cheatutils.webui.ApiBase;
import org.apache.http.MethodNotSupportedException;

public abstract class SimpleConfigApi<T>
extends ApiBase {
    private final String route;
    private final Class<T> clazz;

    public SimpleConfigApi(String route, Class<T> clazz) {
        this.route = route;
        this.clazz = clazz;
    }

    @Override
    public String getRoute() {
        return this.route;
    }

    @Override
    public String get() throws MethodNotSupportedException {
        return this.gson.toJson(this.getConfig());
    }

    @Override
    public String post(String body) throws MethodNotSupportedException {
        Object config = this.gson.fromJson(body, this.clazz);
        if (config != null) {
            if (config instanceof ValidatableConfig) {
                ValidatableConfig validatableConfig = (ValidatableConfig)config;
                validatableConfig.validate();
            }
            this.setConfig(config);
            ConfigStore.instance.requestWrite();
        }
        return this.get();
    }

    protected abstract T getConfig();

    protected abstract void setConfig(T var1);
}

