/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.HelpText;
import com.zergatul.cheatutils.scripting.api.Root;
import com.zergatul.cheatutils.scripting.api.VisibilityCheck;
import com.zergatul.cheatutils.webui.ApiBase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpException;

public class ScriptsDocsApi
extends ApiBase {
    @Override
    public String getRoute() {
        return "scripts-doc";
    }

    @Override
    public String get(String id) throws HttpException {
        ApiType[] types = VisibilityCheck.getTypes(id);
        if (types == null) {
            return null;
        }
        return this.gson.toJson(this.generateRootRefs(types));
    }

    private List<String> generateRootRefs(ApiType[] types) {
        ArrayList<String> refs = new ArrayList<String>();
        this.getFields(Root.class, false).sorted(Comparator.comparing(Field::getName)).forEach(field -> {
            this.getMethods(field.getType(), types).forEach(method -> refs.add(this.generateHtml(field.getName(), (Method)method)));
            this.getFields(field.getType(), true).forEach(f -> {
                String prefix = field.getName() + "." + f.getName();
                refs.addAll(this.generateChildRefs(prefix, f.getType(), types));
            });
        });
        return refs;
    }

    private List<String> generateChildRefs(String prefix, Class<?> clazz, ApiType[] types) {
        ArrayList<String> refs = new ArrayList<String>();
        this.getMethods(clazz, types).forEach(method -> refs.add(this.generateHtml(prefix, (Method)method)));
        Field[] fields = clazz.getDeclaredFields();
        Arrays.stream(fields).filter(f -> Modifier.isPublic(f.getModifiers())).sorted(Comparator.comparing(Field::getName)).forEach(field -> this.getFields(field.getType(), true).forEach(f -> {
            String prefixInner = prefix + "." + field.getName() + "." + f.getName();
            refs.addAll(this.generateChildRefs(prefixInner, f.getType(), types));
        }));
        return refs;
    }

    private Stream<Method> getMethods(Class<?> clazz, ApiType[] types) {
        Method[] methods = clazz.getMethods();
        return Arrays.stream(methods).filter(m -> {
            if (m.getDeclaringClass() == Object.class) {
                return false;
            }
            if (!VisibilityCheck.isOk(m, types)) {
                return false;
            }
            return Modifier.isPublic(m.getModifiers());
        }).sorted(Comparator.comparing(Method::getName));
    }

    private Stream<Field> getFields(Class<?> clazz, boolean isInstance) {
        return Arrays.stream(clazz.getFields()).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> isInstance ^ Modifier.isStatic(f.getModifiers()));
    }

    private String generateHtml(String prefix, Method method) {
        HelpText helpText;
        String space = "&nbsp;";
        Parameter[] parameters = method.getParameters();
        String paramsStr = Arrays.stream(parameters).map(p -> this.formatClass(p.getType()) + "&nbsp;" + p.getName()).reduce((s1, s2) -> s1 + ",&nbsp;" + s2).orElse("");
        Object returnStr = "";
        if (method.getReturnType() != Void.TYPE) {
            returnStr = "&nbsp;\u2192&nbsp;" + this.formatClass(method.getReturnType());
        }
        String comment = "";
        if (method.isAnnotationPresent(HelpText.class) && (helpText = method.getAnnotation(HelpText.class)).value() != null && helpText.value().length() > 0) {
            comment = this.formatComment("/* " + helpText.value() + " */");
        }
        return prefix + ".<span class=\"method\">" + method.getName() + "</span>(" + paramsStr + ")" + (String)returnStr + comment;
    }

    private String formatClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.formatClass(clazz.getComponentType()) + "[]";
        }
        String name = clazz == String.class ? "string" : (clazz == Double.TYPE ? "float" : clazz.getName());
        return "<span class=\"class\">" + name + "</span>";
    }

    private String formatComment(String text) {
        return "<span class=\"comment\">&nbsp;" + StringEscapeUtils.escapeHtml4((String)text) + "</span>";
    }
}

