/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.schematics.InvalidFormatException;
import com.zergatul.cheatutils.schematics.SchemaFile;
import com.zergatul.cheatutils.schematics.SchemaFormatFactory;
import com.zergatul.cheatutils.webui.ApiBase;
import java.io.IOException;
import java.util.Base64;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.http.HttpException;

public class SchematicaUploadApi
extends ApiBase {
    @Override
    public String getRoute() {
        return "schematica-upload";
    }

    @Override
    public String post(String body) throws HttpException {
        SchemaFile schema;
        Request request = (Request)this.gson.fromJson(body, Request.class);
        byte[] data = Base64.getDecoder().decode(request.file);
        try {
            schema = SchemaFormatFactory.parse(data, request.name);
        }
        catch (InvalidFormatException | IOException e) {
            return this.gson.toJson((Object)new ErrorResponse(e.getMessage()));
        }
        return this.gson.toJson((Object)new SuccessResponse(schema.getSummary(), schema.getPalette(), schema.getWidth(), schema.getHeight(), schema.getLength()));
    }

    public record Request(String file, String name) {
    }

    public record ErrorResponse(String error) {
    }

    public record SuccessResponse(int[] summary, BlockState[] palette, int width, int height, int length) {
    }
}

