/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.controllers.SchematicaController;
import com.zergatul.cheatutils.schematics.InvalidFormatException;
import com.zergatul.cheatutils.schematics.PlacingSettings;
import com.zergatul.cheatutils.schematics.SchemaFile;
import com.zergatul.cheatutils.schematics.SchemaFormatFactory;
import com.zergatul.cheatutils.webui.ApiBase;
import java.io.IOException;
import java.util.Base64;
import org.apache.http.HttpException;

public class SchematicaPlaceApi
extends ApiBase {
    @Override
    public String getRoute() {
        return "schematica-place";
    }

    @Override
    public String post(String body) throws HttpException {
        SchemaFile schema;
        Request request = (Request)this.gson.fromJson(body, Request.class);
        byte[] data = Base64.getDecoder().decode(request.file);
        try {
            schema = SchemaFormatFactory.parse(data, request.name);
        }
        catch (InvalidFormatException | IOException e) {
            throw new HttpException(e.getMessage());
        }
        SchematicaController.instance.place(schema, request.placing);
        return "{}";
    }

    @Override
    public String delete(String id) throws HttpException {
        SchematicaController.instance.clear();
        return "{}";
    }

    public record Request(String file, String name, PlacingSettings placing) {
    }
}

