/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.webui.ApiBase;
import org.apache.http.HttpException;

public class EntityConfigMoveApi
extends ApiBase {
    @Override
    public String getRoute() {
        return "entities-move";
    }

    @Override
    public String post(String body) throws HttpException {
        Request request = (Request)this.gson.fromJson(body, Request.class);
        if (request.clazz == null) {
            return this.gson.toJson((Object)new Response(false, "Class is null"));
        }
        boolean up = request.direction.equals("up");
        boolean down = request.direction.equals("down");
        if (!up && !down) {
            return this.gson.toJson((Object)new Response(false, "Invalid direction"));
        }
        ImmutableList<EntityTracerConfig> list = ConfigStore.instance.getConfig().entities.configs;
        int index = list.indexOf(c -> c.clazz == request.clazz);
        if (index < 0) {
            return this.gson.toJson((Object)new Response(false, "Cannot find class in list"));
        }
        if (index == 0 && up) {
            return this.gson.toJson((Object)new Response(true, "Cannot move up"));
        }
        if (index == list.size() - 1 && down) {
            return this.gson.toJson((Object)new Response(true, "Cannot move down"));
        }
        ConfigStore.instance.getConfig().entities.configs = up ? list.swap(index, index - 1) : list.swap(index, index + 1);
        ConfigStore.instance.requestWrite();
        return this.gson.toJson((Object)new Response(true, null));
    }

    public record Request(String direction, Class clazz) {
    }

    public record Response(boolean ok, String message) {
    }
}

