/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.webui.ApiBase;
import com.zergatul.cheatutils.wrappers.ClassRemapper;
import org.apache.http.MethodNotSupportedException;

public class EntitiesConfigApi
extends ApiBase {
    @Override
    public String getRoute() {
        return "entities";
    }

    @Override
    public synchronized String get() throws MethodNotSupportedException {
        ImmutableList<EntityTracerConfig> list = ConfigStore.instance.getConfig().entities.configs;
        Object[] result = list.stream().toArray();
        return this.gson.toJson((Object)result);
    }

    @Override
    public synchronized String post(String body) throws MethodNotSupportedException {
        EntityTracerConfig jsonConfig = (EntityTracerConfig)this.gson.fromJson(body, EntityTracerConfig.class);
        EntityTracerConfig config = ConfigStore.instance.getConfig().entities.configs.stream().filter(c -> c.clazz == jsonConfig.clazz).findFirst().orElse(null);
        if (config != null) {
            throw new MethodNotSupportedException("Entity config already exists.");
        }
        config = EntityTracerConfig.createDefault(jsonConfig.clazz);
        ConfigStore.instance.getConfig().entities.add(config);
        ConfigStore.instance.requestWrite();
        return this.gson.toJson((Object)config);
    }

    @Override
    public synchronized String put(String className, String body) throws MethodNotSupportedException {
        EntityTracerConfig jsonConfig = (EntityTracerConfig)this.gson.fromJson(body, EntityTracerConfig.class);
        String obfClassName = ClassRemapper.toObf(className);
        if (!obfClassName.equals(jsonConfig.clazz.getName())) {
            throw new MethodNotSupportedException("Entity class name don't match.");
        }
        EntityTracerConfig config = ConfigStore.instance.getConfig().entities.configs.stream().filter(c -> c.clazz == jsonConfig.clazz).findFirst().orElse(null);
        if (config == null) {
            throw new MethodNotSupportedException("Cannot find entity config.");
        }
        config.copyFrom(jsonConfig);
        ConfigStore.instance.requestWrite();
        return this.gson.toJson((Object)config);
    }

    @Override
    public synchronized String delete(String className) throws MethodNotSupportedException {
        String obfClassName = ClassRemapper.toObf(className);
        EntityTracerConfig config = ConfigStore.instance.getConfig().entities.configs.stream().filter(c -> c.clazz.getName().equals(obfClassName)).findFirst().orElse(null);
        ConfigStore.instance.getConfig().entities.remove(config);
        ConfigStore.instance.requestWrite();
        return "{ ok: true }";
    }
}

