/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.webui;

import com.sun.net.httpserver.HttpServer;
import com.zergatul.cheatutils.webui.ApiHandler;
import com.zergatul.cheatutils.webui.AssetsHandler;
import com.zergatul.cheatutils.webui.StaticFilesHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigHttpServer {
    public static ConfigHttpServer instance = new ConfigHttpServer();
    private final Logger logger = LogManager.getLogger(ConfigHttpServer.class);
    private HttpServer server;
    private String uri;

    private ConfigHttpServer() {
    }

    public void start() {
        int port = 0;
        for (int i = 5005; i < 5100; ++i) {
            if (!ConfigHttpServer.isAvailable(i)) continue;
            port = i;
            break;
        }
        if (port == 0) {
            this.logger.debug("Cannot start http server");
            return;
        }
        try {
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.server.createContext("/api/", new ApiHandler());
        this.server.createContext("/assets/", new AssetsHandler());
        this.server.createContext("/", new StaticFilesHandler());
        this.server.setExecutor(null);
        this.server.start();
        this.uri = "http://localhost:" + port + "/";
        this.logger.debug("Http server started");
    }

    public String getUrl() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailable(int port) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(port);
            socket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

