/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import java.util.LinkedList;

public class ThreadLoadCounter {
    private static final int KEEP_SECONDS = 5;
    private volatile boolean isWaiting = true;
    private final LinkedList<Entry> entries = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWait() {
        long now = System.nanoTime();
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            this.clearOldEntries();
            this.updateLast(now);
            this.entries.addLast(new Entry(true, now));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoad() {
        long now = System.nanoTime();
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            this.clearOldEntries();
            this.updateLast(now);
            this.entries.addLast(new Entry(false, now));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            this.entries.clear();
            this.entries.addLast(new Entry(true, System.nanoTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLoad(int seconds) {
        long now = System.nanoTime();
        long from = now - (long)seconds * 1000000000L;
        LinkedList<Entry> linkedList = this.entries;
        synchronized (linkedList) {
            this.updateLast(now);
            long totalWait = 0L;
            long totalLoad = 0L;
            for (Entry entry : this.entries) {
                if (entry.isWaiting) {
                    totalWait += entry.getIntersection(from, now);
                    continue;
                }
                totalLoad += entry.getIntersection(from, now);
            }
            if (totalLoad + totalWait == 0L) {
                return 0.0;
            }
            return 1.0 * (double)totalLoad / (double)(totalWait + totalLoad);
        }
    }

    private void updateLast(long now) {
        if (this.entries.size() > 0) {
            this.entries.getLast().end = now;
        }
    }

    private void clearOldEntries() {
        long now = System.nanoTime();
        while (this.entries.size() > 0) {
            Entry first = this.entries.getFirst();
            if (now - first.end <= 5000000000L) break;
            this.entries.removeFirst();
        }
    }

    private static class Entry {
        public boolean isWaiting;
        public long start;
        public long end;

        public Entry(boolean isWaiting, long start) {
            this.isWaiting = isWaiting;
            this.start = start;
            this.end = start;
        }

        public long getIntersection(long from, long to) {
            from = Math.max(this.start, from);
            to = Math.min(this.end, to);
            long result = to - from;
            return Math.max(0L, result);
        }
    }
}

