/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.utils.InventorySlot;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InventoryUtils {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void moveItemStack(InventorySlot fromSlot, InventorySlot toSlot) {
        if (InventoryUtils.mc.f_91074_ == null) {
            return;
        }
        ItemStack air = new ItemStack((ItemLike)Items.f_41852_, 1);
        ItemStack fromItemStack = fromSlot.get();
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.put(fromSlot.toMenuIndex(), (Object)air);
        NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), fromSlot.toMenuIndex(), 0, ClickType.PICKUP, fromItemStack, (Int2ObjectMap)int2objectmap));
        fromSlot.set(air);
        ItemStack toItemStack = toSlot.get();
        if (toItemStack.m_41619_()) {
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(toSlot.toMenuIndex(), (Object)fromItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), toSlot.toMenuIndex(), 0, ClickType.PICKUP, air, (Int2ObjectMap)int2objectmap));
            toSlot.set(fromItemStack);
        } else {
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(toSlot.toMenuIndex(), (Object)fromItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), toSlot.toMenuIndex(), 0, ClickType.PICKUP, toItemStack, (Int2ObjectMap)int2objectmap));
            toSlot.set(fromItemStack);
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(fromSlot.toMenuIndex(), (Object)toItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), fromSlot.toMenuIndex(), 0, ClickType.PICKUP, air, (Int2ObjectMap)int2objectmap));
            fromSlot.set(toItemStack);
        }
        if (!(InventoryUtils.mc.f_91080_ instanceof InventoryScreen)) {
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClosePacket(0));
        }
    }

    public static void swapItemStack(InventorySlot fromSlot, InventorySlot toSlot) {
        if (InventoryUtils.mc.f_91074_ == null) {
            return;
        }
        ItemStack fromItemStack = fromSlot.get();
        ItemStack toItemStack = toSlot.get();
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.put(fromSlot.toMenuIndex(), (Object)toItemStack);
        int2objectmap.put(toSlot.toMenuIndex(), (Object)fromItemStack);
        NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), fromSlot.toMenuIndex(), toSlot.toInventoryIndex(), ClickType.SWAP, new ItemStack((ItemLike)Items.f_41852_, 1), (Int2ObjectMap)int2objectmap));
        fromSlot.set(toItemStack);
        toSlot.set(fromItemStack);
    }

    public static void dropItemStacks(List<InventorySlot> slots) {
        if (slots == null || slots.size() == 0) {
            return;
        }
        if (InventoryUtils.mc.f_91074_ == null) {
            return;
        }
        for (InventorySlot slot : slots) {
            ItemStack air = new ItemStack((ItemLike)Items.f_41852_, 1);
            ItemStack fromItemStack = slot.get();
            Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(slot.toMenuIndex(), (Object)air);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), slot.toMenuIndex(), 0, ClickType.PICKUP, fromItemStack, (Int2ObjectMap)int2objectmap));
            slot.set(air);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), -999, 0, ClickType.PICKUP, air, (Int2ObjectMap)new Int2ObjectOpenHashMap()));
        }
        if (!(InventoryUtils.mc.f_91080_ instanceof InventoryScreen)) {
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClosePacket(0));
        }
    }

    public static void addItemStack(InventorySlot fromSlot, InventorySlot toSlot) {
        ItemStack sourceItemStack = fromSlot.get();
        ItemStack destItemStack = toSlot.get();
        int stackSize = destItemStack.m_41741_();
        if (destItemStack.m_41613_() >= stackSize) {
            return;
        }
        if (!destItemStack.m_41619_() && !ItemStack.m_150942_((ItemStack)sourceItemStack, (ItemStack)destItemStack)) {
            return;
        }
        ItemStack air = new ItemStack((ItemLike)Items.f_41852_, 1);
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.put(fromSlot.toMenuIndex(), (Object)air);
        NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), fromSlot.toMenuIndex(), 0, ClickType.PICKUP, sourceItemStack, (Int2ObjectMap)int2objectmap));
        fromSlot.set(air);
        int total = sourceItemStack.m_41613_() + destItemStack.m_41613_();
        if (total <= stackSize) {
            ItemStack newDestItemStack = destItemStack.m_255036_(total);
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(toSlot.toMenuIndex(), (Object)newDestItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), toSlot.toMenuIndex(), 0, ClickType.PICKUP, air, (Int2ObjectMap)int2objectmap));
            toSlot.set(newDestItemStack);
        } else {
            int remainder = total - stackSize;
            ItemStack newDestItemStack = destItemStack.m_255036_(stackSize);
            ItemStack remainderItemStack = destItemStack.m_255036_(remainder);
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(toSlot.toMenuIndex(), (Object)newDestItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), toSlot.toMenuIndex(), 0, ClickType.PICKUP, remainderItemStack, (Int2ObjectMap)int2objectmap));
            toSlot.set(newDestItemStack);
            int2objectmap = new Int2ObjectOpenHashMap();
            int2objectmap.put(fromSlot.toMenuIndex(), (Object)remainderItemStack);
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundContainerClickPacket(0, InventoryUtils.mc.f_91074_.f_36095_.m_182424_(), fromSlot.toMenuIndex(), 0, ClickType.PICKUP, air, (Int2ObjectMap)int2objectmap));
            fromSlot.set(remainderItemStack);
        }
    }

    public static boolean hasItem(Item item) {
        if (InventoryUtils.mc.f_91074_ == null) {
            return false;
        }
        Inventory inventory = InventoryUtils.mc.f_91074_.m_150109_();
        for (int i = 0; i < 36; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean selectItem(Item item, int slot) {
        if (InventoryUtils.mc.f_91074_ == null) {
            return false;
        }
        Inventory inventory = InventoryUtils.mc.f_91074_.m_150109_();
        if (inventory.m_8020_(slot).m_150930_(item)) {
            return true;
        }
        for (int i = 0; i < 36; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            InventoryUtils.moveItemStack(new InventorySlot(i), new InventorySlot(slot));
            return true;
        }
        return false;
    }
}

