/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import com.zergatul.cheatutils.modules.esp.FreeCam;
import com.zergatul.cheatutils.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;

public class FreeCamPath {
    private final FreeCam freeCam;
    private final List<Entry> entries = new ArrayList<Entry>();

    public FreeCamPath(FreeCam freeCam) {
        this.freeCam = freeCam;
    }

    public void add(double time) {
        if (!this.freeCam.isActive()) {
            return;
        }
        time = MathUtils.clamp(time, 0.0, 3600000.0);
        this.entries.add(new Entry(new Vec3(this.freeCam.getX(), this.freeCam.getY(), this.freeCam.getZ()), this.freeCam.getXRot(), this.freeCam.getYRot(), time));
    }

    public void clear() {
        this.entries.clear();
    }

    public List<Entry> get() {
        return this.entries;
    }

    public Entry interpolate(double time) {
        for (int i = 1; i < this.entries.size(); ++i) {
            Entry e2 = this.entries.get(i);
            if (time < e2.time) {
                Entry e1 = this.entries.get(i - 1);
                double factor = time / e2.time;
                return this.interpolate(e1, e2, factor);
            }
            time -= e2.time;
        }
        return null;
    }

    private Entry interpolate(Entry e1, Entry e2, double factor) {
        Vec3 pos = new Vec3(e1.position.f_82479_ + (e2.position.f_82479_ - e1.position.f_82479_) * factor, e1.position.f_82480_ + (e2.position.f_82480_ - e1.position.f_82480_) * factor, e1.position.f_82481_ + (e2.position.f_82481_ - e1.position.f_82481_) * factor);
        double xRot = e1.xRot + (e2.xRot - e1.xRot) * factor;
        double yRot = e1.yRot + (e2.yRot - e1.yRot) * factor;
        return new Entry(pos, xRot, yRot, 0.0);
    }

    public record Entry(Vec3 position, double xRot, double yRot, double time) {
    }
}

