/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.mixins.common.accessors.HolderReferenceAccessor;
import com.zergatul.cheatutils.webui.EntityInfoApi;
import com.zergatul.cheatutils.wrappers.ClassRemapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.DimensionTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    private static Logger logger = LogManager.getLogger(EntityInfoApi.class);
    private static List<EntityInfo> classes;
    private static Map<String, EntityInfo> classMap;

    public static List<EntityInfo> getEntityClasses() {
        if (classes == null) {
            EntityUtils.loadEntityClasses();
        }
        return classes;
    }

    public static EntityInfo getEntityClass(String name) {
        if (classMap == null) {
            EntityUtils.loadEntityClasses();
        }
        return classMap.get(name);
    }

    private static synchronized void loadEntityClasses() {
        if (classes != null) {
            return;
        }
        EntityType<?> playerEntityType = Registries.ENTITY_TYPES.getValue(new ResourceLocation("minecraft:player"));
        ArrayList<EntityInfo> finalClasses = new ArrayList<EntityInfo>();
        EntityInfo playerInfo = null;
        try {
            playerInfo = new EntityInfo(Player.class, "minecraft:player");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashSet<EntityInfo> set = new HashSet<EntityInfo>();
        if (playerInfo != null) {
            finalClasses.add(playerInfo);
            set.add(playerInfo);
        }
        FakeLevel level = new FakeLevel();
        Registries.ENTITY_TYPES.getValues().stream().map(et -> {
            if (et == playerEntityType) {
                return null;
            }
            try {
                Entity entity = et.m_20615_(level);
                if (entity == null) {
                    return null;
                }
                EntityInfo info = new EntityInfo(entity.getClass(), Registries.ENTITY_TYPES.getKey((EntityType<?>)et).toString());
                set.add(info);
                return info;
            }
            catch (Throwable throwable) {
                logger.warn("Create entity by EntityType failed");
                logger.warn(et.toString());
                throwable.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).forEach(finalClasses::add);
        HashSet interfaces = new HashSet();
        finalClasses.forEach(ei -> {
            EntityUtils.forEachInterface(ei.clazz, interfaces::add);
            Class clazz = ei.clazz.getSuperclass();
            while (Entity.class.isAssignableFrom(clazz)) {
                try {
                    EntityInfo baseInfo = new EntityInfo(clazz);
                    set.add(baseInfo);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                clazz = clazz.getSuperclass();
            }
        });
        classes = new ArrayList<EntityInfo>();
        classes.addAll(set);
        for (Class iface : interfaces) {
            try {
                classes.add(new EntityInfo(iface));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        classes = classes.stream().sorted((i1, i2) -> i1.simpleName.compareToIgnoreCase(i2.simpleName)).toList();
        classMap = new HashMap<String, EntityInfo>(classes.size());
        for (EntityInfo info : classes) {
            classMap.put(info.clazz.getName(), info);
        }
    }

    private static void forEachInterface(Class<?> clazz, Consumer<Class<?>> consumer) {
        while (clazz != Entity.class) {
            Arrays.stream(clazz.getInterfaces()).forEach(consumer);
            clazz = clazz.getSuperclass();
        }
    }

    public static class EntityInfo {
        public Class clazz;
        public boolean isInterface;
        public String simpleName;
        public List<Class> baseClasses;
        public List<Class> interfaces;
        public String id;

        public EntityInfo(Class clazz) throws Exception {
            this(clazz, null);
        }

        public EntityInfo(Class clazz, String id) throws Exception {
            if (clazz.isInterface()) {
                this.clazz = clazz;
                this.simpleName = this.getSimpleName(clazz);
                this.isInterface = true;
            } else {
                if (!Entity.class.isAssignableFrom(clazz)) {
                    throw new Exception("Not supported");
                }
                this.clazz = clazz;
                this.simpleName = this.getSimpleName(clazz);
                this.id = id;
                this.baseClasses = new ArrayList<Class>();
                while (clazz != Entity.class) {
                    clazz = clazz.getSuperclass();
                    this.baseClasses.add(clazz);
                }
                this.interfaces = new ArrayList<Class>();
                EntityUtils.forEachInterface(this.clazz, iface -> this.interfaces.add((Class)iface));
            }
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EntityInfo) {
                EntityInfo ei = (EntityInfo)obj;
                return ei.clazz == this.clazz;
            }
            return false;
        }

        private String getSimpleName(Class clazz) {
            String rawName = ClassRemapper.fromObf(clazz.getName());
            int index = rawName.lastIndexOf(46);
            if (index < 0) {
                return rawName;
            }
            return rawName.substring(index + 1);
        }
    }

    private static class FakeLevel
    extends Level {
        protected FakeLevel() {
            super((WritableLevelData)new FakeWritableLevelData(), Level.f_46428_, new RegistryAccess(){

                public <E> Optional<Registry<E>> m_6632_(ResourceKey<? extends Registry<? extends E>> p_123085_) {
                    if (p_123085_.equals((Object)net.minecraft.core.registries.Registries.f_268580_)) {
                        Registry<DamageType> x = FakeLevel.createDamageTypeRegistry();
                        return Optional.of(x);
                    }
                    return Optional.empty();
                }

                public Stream<RegistryAccess.RegistryEntry<?>> m_206193_() {
                    return null;
                }
            }, FakeLevel.createHolder(), () -> null, true, true, 0L, 0);
        }

        private static Holder<DimensionType> createHolder() {
            Holder.Reference holder = Holder.Reference.m_254896_((HolderOwner)new HolderOwner<DimensionType>(){

                public boolean m_254921_(HolderOwner<DimensionType> p_255875_) {
                    return false;
                }
            }, (ResourceKey)ResourceKey.m_135785_((ResourceKey)net.minecraft.core.registries.Registries.f_256787_, (ResourceLocation)Level.f_46428_.m_135782_()));
            FakeBootstrapContext context = new FakeBootstrapContext();
            DimensionTypes.m_236473_((BootstapContext)context);
            ((HolderReferenceAccessor)holder).bindValue_CU(context.overworld);
            return holder;
        }

        private static Registry<DamageType> createDamageTypeRegistry() {
            return new Registry<DamageType>(){

                public ResourceKey<? extends Registry<DamageType>> m_123023_() {
                    return null;
                }

                @Nullable
                public ResourceLocation getKey(DamageType p_123006_) {
                    return null;
                }

                public Optional<ResourceKey<DamageType>> getResourceKey(DamageType p_123008_) {
                    return Optional.empty();
                }

                public int getId(@Nullable DamageType p_122977_) {
                    return 0;
                }

                @Nullable
                public DamageType get(@Nullable ResourceKey<DamageType> p_122980_) {
                    return null;
                }

                @Nullable
                public DamageType get(@Nullable ResourceLocation p_123002_) {
                    return null;
                }

                public Lifecycle lifecycle(DamageType p_123012_) {
                    return null;
                }

                public Lifecycle m_203658_() {
                    return null;
                }

                public Set<ResourceLocation> m_6566_() {
                    return null;
                }

                public Set<Map.Entry<ResourceKey<DamageType>, DamageType>> m_6579_() {
                    return null;
                }

                public Set<ResourceKey<DamageType>> m_214010_() {
                    return null;
                }

                public Optional<Holder.Reference<DamageType>> m_213642_(RandomSource p_235781_) {
                    return Optional.empty();
                }

                public boolean m_7804_(ResourceLocation p_123011_) {
                    return false;
                }

                public boolean m_142003_(ResourceKey<DamageType> p_175475_) {
                    return false;
                }

                public Registry<DamageType> m_203521_() {
                    return null;
                }

                public Holder.Reference<DamageType> createIntrusiveHolder(DamageType p_206068_) {
                    return null;
                }

                public Optional<Holder.Reference<DamageType>> m_203300_(int p_206051_) {
                    return Optional.empty();
                }

                public Optional<Holder.Reference<DamageType>> m_203636_(ResourceKey<DamageType> p_206050_) {
                    return Optional.of(Holder.Reference.m_254896_((HolderOwner)new HolderOwner<DamageType>(){

                        public boolean m_254921_(HolderOwner<DamageType> p_255875_) {
                            return false;
                        }
                    }, p_206050_));
                }

                public Holder<DamageType> wrapAsHolder(DamageType p_263382_) {
                    return null;
                }

                public Stream<Holder.Reference<DamageType>> m_203611_() {
                    return null;
                }

                public Optional<HolderSet.Named<DamageType>> m_203431_(TagKey<DamageType> p_206052_) {
                    return Optional.empty();
                }

                public HolderSet.Named<DamageType> m_203561_(TagKey<DamageType> p_206045_) {
                    return null;
                }

                public Stream<Pair<TagKey<DamageType>, HolderSet.Named<DamageType>>> m_203612_() {
                    return null;
                }

                public Stream<TagKey<DamageType>> m_203613_() {
                    return null;
                }

                public void m_203635_() {
                }

                public void m_203652_(Map<TagKey<DamageType>, List<Holder<DamageType>>> p_205997_) {
                }

                public HolderOwner<DamageType> m_255331_() {
                    return null;
                }

                public HolderLookup.RegistryLookup<DamageType> m_255303_() {
                    return null;
                }

                @Nullable
                public DamageType byId(int p_122651_) {
                    return null;
                }

                public int m_13562_() {
                    return 0;
                }

                @NotNull
                public Iterator<DamageType> iterator() {
                    return null;
                }
            };
        }

        public void m_7260_(BlockPos p_46612_, BlockState p_46613_, BlockState p_46614_, int p_46615_) {
        }

        public void m_262808_(@Nullable Player p_262953_, double p_263004_, double p_263398_, double p_263376_, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
        }

        public void m_214150_(@Nullable Player p_220363_, double p_220364_, double p_220365_, double p_220366_, SoundEvent p_220367_, SoundSource p_220368_, float p_220369_, float p_220370_, long p_220371_) {
        }

        public void m_213890_(@Nullable Player p_220372_, Entity p_220373_, Holder<SoundEvent> p_263500_, SoundSource p_220375_, float p_220376_, float p_220377_, long p_220378_) {
        }

        public String m_46464_() {
            return null;
        }

        @Nullable
        public Entity m_6815_(int p_46492_) {
            return null;
        }

        @Nullable
        public MapItemSavedData m_7489_(String p_46650_) {
            return null;
        }

        public void m_142325_(String p_151533_, MapItemSavedData p_151534_) {
        }

        public int m_7354_() {
            return 0;
        }

        public void m_6801_(int p_46506_, BlockPos p_46507_, int p_46508_) {
        }

        public Scoreboard m_6188_() {
            return new Scoreboard();
        }

        public RecipeManager m_7465_() {
            return null;
        }

        protected LevelEntityGetter<Entity> m_142646_() {
            return null;
        }

        public LevelTickAccess<Block> m_183326_() {
            return null;
        }

        public LevelTickAccess<Fluid> m_183324_() {
            return null;
        }

        public ChunkSource m_7726_() {
            return null;
        }

        public void m_5898_(@Nullable Player p_46771_, int p_46772_, BlockPos p_46773_, int p_46774_) {
        }

        public void m_214171_(GameEvent p_220404_, Vec3 p_220405_, GameEvent.Context p_220406_) {
        }

        public RegistryAccess m_9598_() {
            return null;
        }

        public FeatureFlagSet m_246046_() {
            return FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244571_);
        }

        public float m_7717_(Direction p_45522_, boolean p_45523_) {
            return 0.0f;
        }

        public List<? extends Player> m_6907_() {
            return null;
        }

        public Holder<Biome> m_203675_(int p_204159_, int p_204160_, int p_204161_) {
            return null;
        }
    }

    private static class FakeBootstrapContext
    implements BootstapContext<DimensionType> {
        public DimensionType overworld;

        private FakeBootstrapContext() {
        }

        public Holder.Reference<DimensionType> register(ResourceKey<DimensionType> p_256008_, DimensionType p_256454_, Lifecycle p_255725_) {
            if (p_256008_ == BuiltinDimensionTypes.f_223538_) {
                this.overworld = p_256454_;
            }
            return null;
        }

        public <S> HolderGetter<S> m_255420_(ResourceKey<? extends Registry<? extends S>> p_256410_) {
            return null;
        }
    }

    private static class FakeWritableLevelData
    implements WritableLevelData {
        private FakeWritableLevelData() {
        }

        public void m_6395_(int p_78651_) {
        }

        public void m_6397_(int p_78652_) {
        }

        public void m_6400_(int p_78653_) {
        }

        public void m_7113_(float p_78648_) {
        }

        public int m_6789_() {
            return 0;
        }

        public int m_6527_() {
            return 0;
        }

        public int m_6526_() {
            return 0;
        }

        public float m_6790_() {
            return 0.0f;
        }

        public long m_6793_() {
            return 0L;
        }

        public long m_6792_() {
            return 0L;
        }

        public boolean m_6534_() {
            return false;
        }

        public boolean m_6533_() {
            return false;
        }

        public void m_5565_(boolean p_78171_) {
        }

        public boolean m_5466_() {
            return false;
        }

        public GameRules m_5470_() {
            return null;
        }

        public Difficulty m_5472_() {
            return null;
        }

        public boolean m_5474_() {
            return false;
        }
    }
}

