/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.utils.BlockPlacingMethod;
import com.zergatul.cheatutils.utils.Rotation;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlockUtils {
    private static final Minecraft mc = Minecraft.m_91087_();

    public static PlaceBlockPlan getPlacingPlan(BlockPos pos, boolean attachToAir) {
        return BlockUtils.getPlacingPlan(pos, attachToAir, BlockPlacingMethod.ANY);
    }

    public static PlaceBlockPlan getPlacingPlan(BlockPos pos, boolean attachToAir, BlockPlacingMethod method) {
        return BlockUtils.getPlacingPlan(pos, attachToAir, method, Blocks.f_50069_.m_49966_());
    }

    public static PlaceBlockPlan getPlacingPlan(BlockPos pos, boolean attachToAir, BlockPlacingMethod method, BlockState finalState) {
        Vec3 target;
        CollisionContext collisioncontext;
        if (BlockUtils.mc.f_91073_ == null) {
            return null;
        }
        BlockState currentState = BlockUtils.mc.f_91073_.m_8055_(pos);
        if (!currentState.m_247087_()) {
            return null;
        }
        if (BlockUtils.mc.f_91074_ != null && !BlockUtils.mc.f_91073_.m_45752_(finalState, pos, collisioncontext = CollisionContext.m_82750_((Entity)BlockUtils.mc.f_91074_))) {
            return null;
        }
        for (CollisionContext direction : method.getAllowedDirections()) {
            Vec3 target2;
            BlockPos neighbourPos = pos.m_121945_((Direction)direction);
            BlockState neighbourState = BlockUtils.mc.f_91073_.m_8055_(neighbourPos);
            if (neighbourState.m_247087_() || (target2 = method.getTarget(BlockUtils.mc.f_91074_.m_146892_(), pos, direction.m_122424_(), false)) == null) continue;
            return new PlaceBlockPlan(pos.m_7949_(), direction.m_122424_(), neighbourPos, target2, method.getRotation());
        }
        if (attachToAir && (target = method.getTarget(BlockUtils.mc.f_91074_.m_146892_(), pos, Direction.UP, true)) != null) {
            return new PlaceBlockPlan(pos.m_7949_(), Direction.UP, pos.m_7949_(), target, method.getRotation());
        }
        return null;
    }

    public static void applyPlacingPlan(PlaceBlockPlan plan, boolean useShift) {
        BlockUtils.placeBlock(plan.destination, plan.direction, plan.neighbour, plan.target, plan.rotation, useShift);
    }

    private static void placeBlock(BlockPos destination, Direction direction, BlockPos neighbour, Vec3 target, Rotation rotation, boolean useShift) {
        boolean emulateShift;
        if (BlockUtils.mc.f_91074_ == null) {
            return;
        }
        BlockHitResult hit = new BlockHitResult(target, direction, neighbour, false);
        boolean bl = emulateShift = useShift && !BlockUtils.mc.f_91074_.m_6144_();
        if (emulateShift) {
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundPlayerCommandPacket((Entity)BlockUtils.mc.f_91074_, ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY));
        }
        if (rotation != null) {
            BlockUtils.mc.f_91074_.f_108617_.m_104955_((Packet)new ServerboundMovePlayerPacket.Rot(rotation.yRot(), rotation.xRot(), BlockUtils.mc.f_91074_.m_20096_()));
        }
        InteractionHand hand = InteractionHand.MAIN_HAND;
        InteractionResult result = BlockUtils.mc.f_91072_.m_233732_(BlockUtils.mc.f_91074_, InteractionHand.MAIN_HAND, hit);
        if (result.m_19077_() && result.m_19080_()) {
            BlockUtils.mc.f_91074_.m_6674_(hand);
        }
        if (emulateShift) {
            NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundPlayerCommandPacket((Entity)BlockUtils.mc.f_91074_, ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY));
        }
    }

    public record PlaceBlockPlan(BlockPos destination, Direction direction, BlockPos neighbour, Vec3 target, Rotation rotation) {
        public PlaceBlockPlan(BlockPos destination, Direction direction, BlockPos neighbour) {
            this(destination, direction, neighbour, new Vec3((double)((float)destination.m_123341_() + 0.5f) + (double)direction.m_122424_().m_122429_() * 0.5, (double)((float)destination.m_123342_() + 0.5f) + (double)direction.m_122424_().m_122430_() * 0.5, (double)((float)destination.m_123343_() + 0.5f) + (double)direction.m_122424_().m_122431_() * 0.5), null);
        }
    }
}

