/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.utils;

import com.zergatul.cheatutils.utils.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;

public enum BlockPlacingMethod {
    ANY,
    BOTTOM_SLAB,
    TOP_SLAB,
    FACING_TOP,
    FACING_BOTTOM,
    FACING_EAST,
    FACING_WEST,
    FACING_SOUTH,
    FACING_NORTH,
    FROM_TOP;


    public Vec3 getTarget(Vec3 playerPos, BlockPos blockPos, Direction direction, boolean airPlace) {
        return switch (this) {
            case BOTTOM_SLAB -> BlockPlacingMethod.getBottomSlabTarget(playerPos, blockPos, direction, airPlace);
            case TOP_SLAB -> BlockPlacingMethod.getTopSlabTarget(playerPos, blockPos, direction, airPlace);
            default -> BlockPlacingMethod.getTargetDefault(playerPos, blockPos, direction);
        };
    }

    public Rotation getRotation() {
        return switch (this) {
            case FACING_TOP -> new Rotation(90.0f, 0.0f);
            case FACING_BOTTOM -> new Rotation(-90.0f, 0.0f);
            default -> null;
        };
    }

    public Direction[] getAllowedDirections() {
        Direction[] directionArray;
        switch (this) {
            case FROM_TOP: {
                Direction[] directionArray2 = new Direction[1];
                directionArray = directionArray2;
                directionArray2[0] = Direction.DOWN;
                break;
            }
            default: {
                directionArray = Direction.values();
            }
        }
        return directionArray;
    }

    private static Vec3 getTargetDefault(Vec3 playerPos, BlockPos blockPos, Direction direction) {
        return new Vec3((double)((float)blockPos.m_123341_() + 0.5f) + (double)direction.m_122424_().m_122429_() * 0.5, (double)((float)blockPos.m_123342_() + 0.5f) + (double)direction.m_122424_().m_122430_() * 0.5, (double)((float)blockPos.m_123343_() + 0.5f) + (double)direction.m_122424_().m_122431_() * 0.5);
    }

    private static Vec3 getBottomSlabTarget(Vec3 playerPos, BlockPos blockPos, Direction direction, boolean airPlace) {
        if (direction == Direction.UP) {
            return !airPlace ? BlockPlacingMethod.getTargetDefault(playerPos, blockPos, direction) : null;
        }
        if (direction == Direction.DOWN) {
            return null;
        }
        return new Vec3((double)((float)blockPos.m_123341_() + 0.5f) + (double)direction.m_122424_().m_122429_() * 0.5, (double)((float)blockPos.m_123342_() + 0.25f), (double)((float)blockPos.m_123343_() + 0.5f) + (double)direction.m_122424_().m_122431_() * 0.5);
    }

    private static Vec3 getTopSlabTarget(Vec3 playerPos, BlockPos blockPos, Direction direction, boolean airPlace) {
        if (direction == Direction.DOWN) {
            return !airPlace ? BlockPlacingMethod.getTargetDefault(playerPos, blockPos, direction) : null;
        }
        if (direction == Direction.UP) {
            return null;
        }
        return new Vec3((double)((float)blockPos.m_123341_() + 0.5f) + (double)direction.m_122424_().m_122429_() * 0.5, (double)((float)blockPos.m_123342_() + 0.75f), (double)((float)blockPos.m_123343_() + 0.5f) + (double)direction.m_122424_().m_122431_() * 0.5);
    }
}

