/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler.types;

import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.operations.BinaryOperation;
import com.zergatul.cheatutils.scripting.compiler.operations.UnaryOperation;
import com.zergatul.cheatutils.scripting.compiler.types.SArrayType;
import com.zergatul.cheatutils.scripting.compiler.types.SBoolean;
import com.zergatul.cheatutils.scripting.compiler.types.SFloatType;
import com.zergatul.cheatutils.scripting.compiler.types.SIntType;
import com.zergatul.cheatutils.scripting.compiler.types.SStringType;
import com.zergatul.cheatutils.scripting.compiler.types.SVoidType;
import com.zergatul.cheatutils.scripting.generated.ASTAnd;
import com.zergatul.cheatutils.scripting.generated.ASTDiv;
import com.zergatul.cheatutils.scripting.generated.ASTEquality;
import com.zergatul.cheatutils.scripting.generated.ASTFloorDiv;
import com.zergatul.cheatutils.scripting.generated.ASTFloorMod;
import com.zergatul.cheatutils.scripting.generated.ASTGreaterEquals;
import com.zergatul.cheatutils.scripting.generated.ASTGreaterThan;
import com.zergatul.cheatutils.scripting.generated.ASTInequality;
import com.zergatul.cheatutils.scripting.generated.ASTLessEquals;
import com.zergatul.cheatutils.scripting.generated.ASTLessThan;
import com.zergatul.cheatutils.scripting.generated.ASTMinus;
import com.zergatul.cheatutils.scripting.generated.ASTMod;
import com.zergatul.cheatutils.scripting.generated.ASTMult;
import com.zergatul.cheatutils.scripting.generated.ASTNot;
import com.zergatul.cheatutils.scripting.generated.ASTOr;
import com.zergatul.cheatutils.scripting.generated.ASTPlus;
import com.zergatul.cheatutils.scripting.generated.Node;

public abstract class SType {
    public abstract Class<?> getJavaClass();

    public abstract void storeDefaultValue(CompilerMethodVisitor var1);

    public abstract int getLoadInst();

    public abstract int getStoreInst();

    public abstract int getArrayLoadInst();

    public abstract int getArrayStoreInst();

    public abstract boolean isReference();

    public BinaryOperation add(SType other) {
        return null;
    }

    public BinaryOperation subtract(SType other) {
        return null;
    }

    public BinaryOperation multiply(SType other) {
        return null;
    }

    public BinaryOperation divide(SType other) {
        return null;
    }

    public BinaryOperation modulo(SType other) {
        return null;
    }

    public BinaryOperation floorMod(SType other) {
        return null;
    }

    public BinaryOperation floorDiv(SType other) {
        return null;
    }

    public BinaryOperation lessThan(SType other) {
        return null;
    }

    public BinaryOperation greaterThan(SType other) {
        return null;
    }

    public BinaryOperation lessEquals(SType other) {
        return null;
    }

    public BinaryOperation greaterEquals(SType other) {
        return null;
    }

    public BinaryOperation equalsOp(SType other) {
        return null;
    }

    public BinaryOperation notEqualsOp(SType other) {
        return null;
    }

    public BinaryOperation and(SType other) {
        return null;
    }

    public BinaryOperation or(SType other) {
        return null;
    }

    public BinaryOperation binary(Node node, SType other) throws ScriptCompileException {
        if (node instanceof ASTPlus) {
            return this.add(other);
        }
        if (node instanceof ASTMinus) {
            return this.subtract(other);
        }
        if (node instanceof ASTMult) {
            return this.multiply(other);
        }
        if (node instanceof ASTDiv) {
            return this.divide(other);
        }
        if (node instanceof ASTMod) {
            return this.modulo(other);
        }
        if (node instanceof ASTFloorDiv) {
            return this.floorDiv(other);
        }
        if (node instanceof ASTFloorMod) {
            return this.floorMod(other);
        }
        if (node instanceof ASTLessThan) {
            return this.lessThan(other);
        }
        if (node instanceof ASTGreaterThan) {
            return this.greaterThan(other);
        }
        if (node instanceof ASTLessEquals) {
            return this.lessEquals(other);
        }
        if (node instanceof ASTGreaterEquals) {
            return this.greaterEquals(other);
        }
        if (node instanceof ASTEquality) {
            return this.equalsOp(other);
        }
        if (node instanceof ASTInequality) {
            return this.notEqualsOp(other);
        }
        if (node instanceof ASTAnd) {
            return this.and(other);
        }
        if (node instanceof ASTOr) {
            return this.or(other);
        }
        throw new ScriptCompileException(String.format("Unexpected operator %s.", node.getClass().getSimpleName()));
    }

    public UnaryOperation plus() {
        return null;
    }

    public UnaryOperation minus() {
        return null;
    }

    public UnaryOperation not() {
        return null;
    }

    public UnaryOperation unary(Node node) throws ScriptCompileException {
        if (node instanceof ASTPlus) {
            return this.plus();
        }
        if (node instanceof ASTMinus) {
            return this.minus();
        }
        if (node instanceof ASTNot) {
            return this.not();
        }
        throw new ScriptCompileException(String.format("Unexpected operator %s.", node.getClass().getSimpleName()));
    }

    public SType compileGetField(String field, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return null;
    }

    public static SType fromJavaClass(Class<?> type) throws ScriptCompileException {
        if (type == Void.TYPE) {
            return SVoidType.instance;
        }
        if (type == Boolean.TYPE) {
            return SBoolean.instance;
        }
        if (type == Integer.TYPE) {
            return SIntType.instance;
        }
        if (type == Double.TYPE) {
            return SFloatType.instance;
        }
        if (type == String.class) {
            return SStringType.instance;
        }
        if (type.isArray()) {
            return new SArrayType(SType.fromJavaClass(type.getComponentType()));
        }
        throw new ScriptCompileException("Invalid java type.");
    }
}

