/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler.types;

import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.types.SIntType;
import com.zergatul.cheatutils.scripting.compiler.types.SPrimitiveType;
import com.zergatul.cheatutils.scripting.compiler.types.SType;
import org.objectweb.asm.Type;

public class SArrayType
extends SType {
    private final SType type;

    public SArrayType(SType type) {
        this.type = type;
    }

    public SType getElementsType() {
        return this.type;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.type.getJavaClass().arrayType();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public int getLoadInst() {
        return 25;
    }

    @Override
    public int getStoreInst() {
        return 58;
    }

    @Override
    public int getArrayLoadInst() {
        return 50;
    }

    @Override
    public int getArrayStoreInst() {
        return 83;
    }

    @Override
    public void storeDefaultValue(CompilerMethodVisitor visitor) {
        visitor.visitInsn(3);
        if (this.type.isReference()) {
            visitor.visitTypeInsn(189, Type.getInternalName(this.type.getJavaClass()));
        } else {
            visitor.visitIntInsn(188, ((SPrimitiveType)this.type).getArrayTypeInst());
        }
    }

    @Override
    public SType compileGetField(String field, CompilerMethodVisitor visitor) throws ScriptCompileException {
        if (field.equals("length")) {
            visitor.visitInsn(190);
            return SIntType.instance;
        }
        return super.compileGetField(field, visitor);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SArrayType) {
            SArrayType other = (SArrayType)obj;
            return this.type.equals(other.type);
        }
        return super.equals(obj);
    }
}

