/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler.operations;

import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.types.SBoolean;
import com.zergatul.cheatutils.scripting.compiler.types.SFloatType;
import com.zergatul.cheatutils.scripting.compiler.types.SIntType;
import com.zergatul.cheatutils.scripting.compiler.types.SType;
import java.lang.reflect.Method;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class UnaryOperation {
    public static final UnaryOperation NONE = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            throw new ScriptCompileException("Should not be called.");
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
        }
    };
    public static final UnaryOperation PLUS_INT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
        }
    };
    public static final UnaryOperation PLUS_FLOAT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
        }
    };
    public static final UnaryOperation MINUS_INT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
            visitor.visitInsn(116);
        }
    };
    public static final UnaryOperation MINUS_FLOAT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
            visitor.visitInsn(119);
        }
    };
    public static final UnaryOperation INT_TO_FLOAT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) {
            visitor.visitInsn(135);
        }
    };
    public static final UnaryOperation INT_TO_STRING = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
            Method method;
            try {
                method = Integer.class.getDeclaredMethod("toString", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("Cannot find Integer.toString() method.");
            }
            visitor.visitMethodInsn(184, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
        }
    };
    public static final UnaryOperation NOT = new UnaryOperation(){

        @Override
        public SType getType() throws ScriptCompileException {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor visitor) throws ScriptCompileException {
            Label elseLabel = new Label();
            Label endLabel = new Label();
            visitor.visitJumpInsn(154, elseLabel);
            visitor.visitInsn(4);
            visitor.visitJumpInsn(167, endLabel);
            visitor.visitLabel(elseLabel);
            visitor.visitInsn(3);
            visitor.visitLabel(endLabel);
        }
    };

    public abstract SType getType() throws ScriptCompileException;

    public abstract void apply(CompilerMethodVisitor var1) throws ScriptCompileException;
}

