/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler.operations;

import com.zergatul.cheatutils.scripting.compiler.BufferVisitor;
import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.operations.CombinedBinaryOperation;
import com.zergatul.cheatutils.scripting.compiler.operations.UnaryOperation;
import com.zergatul.cheatutils.scripting.compiler.types.SBoolean;
import com.zergatul.cheatutils.scripting.compiler.types.SFloatType;
import com.zergatul.cheatutils.scripting.compiler.types.SIntType;
import com.zergatul.cheatutils.scripting.compiler.types.SStringType;
import com.zergatul.cheatutils.scripting.compiler.types.SType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class BinaryOperation {
    public static final BinaryOperation BOOLEAN_OR_BOOLEAN = new BinaryOperation(){

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(128);
        }
    };
    public static final BinaryOperation BOOLEAN_AND_BOOLEAN = new BinaryOperation(){

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(126);
        }
    };
    public static final BinaryOperation INT_ADD_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(96);
        }
    };
    public static final BinaryOperation INT_SUBTRACT_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(100);
        }
    };
    public static final BinaryOperation INT_MULTIPLY_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(104);
        }
    };
    public static final BinaryOperation INT_DIVIDE_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(108);
        }
    };
    public static final BinaryOperation INT_MODULO_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(112);
        }
    };
    public static final BinaryOperation INT_FLOORDIV_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            Method method;
            right.releaseBuffer(left);
            try {
                method = Math.class.getDeclaredMethod("floorDiv", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("Cannot find Math.floorDiv(int, int) method.");
            }
            left.visitMethodInsn(184, Type.getInternalName(Math.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
        }
    };
    public static final BinaryOperation INT_FLOORMOD_INT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SIntType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            Method method;
            right.releaseBuffer(left);
            try {
                method = Math.class.getDeclaredMethod("floorMod", Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("Cannot find Math.floorMod(int, int) method.");
            }
            left.visitMethodInsn(184, Type.getInternalName(Math.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
        }
    };
    public static final BinaryOperation INT_LESS_INT = new IntCompare(161);
    public static final BinaryOperation INT_GREATER_INT = new IntCompare(163);
    public static final BinaryOperation INT_LESS_EQUALS_INT = new IntCompare(164);
    public static final BinaryOperation INT_GREATER_EQUALS_INT = new IntCompare(162);
    public static final BinaryOperation INT_EQUALS_INT = new IntCompare(159);
    public static final BinaryOperation INT_NOT_EQUALS_INT = new IntCompare(160);
    public static final BinaryOperation FLOAT_ADD_FLOAT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(99);
        }
    };
    public static final BinaryOperation FLOAT_SUBTRACT_FLOAT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(103);
        }
    };
    public static final BinaryOperation FLOAT_MULTIPLY_FLOAT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(107);
        }
    };
    public static final BinaryOperation FLOAT_DIVIDE_FLOAT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(111);
        }
    };
    public static final BinaryOperation FLOAT_MODULO_FLOAT = new BinaryOperation(){

        @Override
        public SType getType() {
            return SFloatType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            left.visitInsn(115);
        }
    };
    public static final BinaryOperation FLOAT_LESS_FLOAT = new FloatCompare(161);
    public static final BinaryOperation FLOAT_GREATER_FLOAT = new FloatCompare(163);
    public static final BinaryOperation FLOAT_LESS_EQUALS_FLOAT = new FloatCompare(164);
    public static final BinaryOperation FLOAT_GREATER_EQUALS_FLOAT = new FloatCompare(162);
    public static final BinaryOperation FLOAT_EQUALS_FLOAT = new FloatCompare(159);
    public static final BinaryOperation FLOAT_NOT_EQUALS_FLOAT = new FloatCompare(160);
    public static final BinaryOperation INT_ADD_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_ADD_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_ADD_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_ADD_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_SUBTRACT_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_SUBTRACT_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_SUBTRACT_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_SUBTRACT_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_MULTIPLY_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_MULTIPLY_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_MULTIPLY_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_MULTIPLY_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_DIVIDE_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_DIVIDE_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_DIVIDE_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_DIVIDE_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_MODULO_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_MODULO_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_MODULO_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_MODULO_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_LESS_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_LESS_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_LESS_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_LESS_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_GREATER_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_GREATER_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_GREATER_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_GREATER_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_LESS_EQUALS_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_LESS_EQUALS_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_LESS_EQUALS_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_LESS_EQUALS_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_GREATER_EQUALS_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_GREATER_EQUALS_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_GREATER_EQUALS_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_GREATER_EQUALS_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_EQUALS_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_EQUALS_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_EQUALS_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_EQUALS_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation INT_NOT_EQUALS_FLOAT = new CombinedBinaryOperation(UnaryOperation.INT_TO_FLOAT, FLOAT_NOT_EQUALS_FLOAT, UnaryOperation.NONE);
    public static final BinaryOperation FLOAT_NOT_EQUALS_INT = new CombinedBinaryOperation(UnaryOperation.NONE, FLOAT_NOT_EQUALS_FLOAT, UnaryOperation.INT_TO_FLOAT);
    public static final BinaryOperation STRING_ADD_STRING = new BinaryOperation(){

        @Override
        public SType getType() {
            return SStringType.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            Method method;
            Constructor constructor;
            boolean stringBuilderLocalVarIndex = true;
            try {
                constructor = StringBuilder.class.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("ASTAdditiveExpression cannot find StringBuilder constructor.");
            }
            left.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
            left.visitVarInsn(58, 1);
            left.visitVarInsn(25, 1);
            left.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", Type.getConstructorDescriptor(constructor), false);
            left.visitVarInsn(25, 1);
            left.visitInsn(95);
            try {
                method = StringBuilder.class.getDeclaredMethod("append", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("ASTAdditiveExpression cannot find StringBuilder.list method.");
            }
            left.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
            right.releaseBuffer(left);
            left.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
            try {
                method = StringBuilder.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("ASTAdditiveExpression cannot find StringBuilder.toString method.");
            }
            left.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
        }
    };
    public static final BinaryOperation STRING_EQUALS_STRING = new BinaryOperation(){

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            Method equalsMethod;
            right.releaseBuffer(left);
            try {
                equalsMethod = Objects.class.getDeclaredMethod("equals", Object.class, Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new ScriptCompileException("ASTEqualityExpression cannot find Objects.equals method.");
            }
            left.visitMethodInsn(184, Type.getInternalName(Objects.class), equalsMethod.getName(), Type.getMethodDescriptor((Method)equalsMethod), false);
        }
    };
    public static final BinaryOperation STRING_NOT_EQUALS_STRING = new BinaryOperation(){

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            STRING_EQUALS_STRING.apply(left, right);
            UnaryOperation.NOT.apply(left);
        }
    };

    public abstract SType getType();

    public abstract void apply(CompilerMethodVisitor var1, BufferVisitor var2) throws ScriptCompileException;

    private static class IntCompare
    extends BinaryOperation {
        private final int opcode;

        public IntCompare(int opcode) {
            this.opcode = opcode;
        }

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            Label elseLabel = new Label();
            Label endLabel = new Label();
            left.visitJumpInsn(this.opcode, elseLabel);
            left.visitInsn(3);
            left.visitJumpInsn(167, endLabel);
            left.visitLabel(elseLabel);
            left.visitInsn(4);
            left.visitLabel(endLabel);
        }
    }

    private static class FloatCompare
    extends BinaryOperation {
        private final int opcode;

        public FloatCompare(int opcode) {
            this.opcode = opcode;
        }

        @Override
        public SType getType() {
            return SBoolean.instance;
        }

        @Override
        public void apply(CompilerMethodVisitor left, BufferVisitor right) throws ScriptCompileException {
            right.releaseBuffer(left);
            Label elseLabel = new Label();
            Label endLabel = new Label();
            left.visitInsn(152);
            left.visitInsn(3);
            left.visitJumpInsn(this.opcode, elseLabel);
            left.visitInsn(3);
            left.visitJumpInsn(167, endLabel);
            left.visitLabel(elseLabel);
            left.visitInsn(4);
            left.visitLabel(endLabel);
        }
    }
}

