/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler;

import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.VariableContext;
import com.zergatul.cheatutils.scripting.compiler.VariableEntry;
import com.zergatul.cheatutils.scripting.compiler.types.SFloatType;
import com.zergatul.cheatutils.scripting.compiler.types.SType;
import java.util.Stack;

public class VariableContextStack {
    private final Stack<VariableContext> stack = new Stack();
    private int index = 2;

    public VariableContextStack() {
        this.stack.add(new VariableContext(this.index));
    }

    public VariableEntry add(String identifier, SType type) throws ScriptCompileException {
        if (identifier != null) {
            this.checkIdentifier(identifier);
        }
        VariableEntry variable = this.stack.peek().add(identifier, type, this.index);
        this.index = type == SFloatType.instance ? (this.index += 2) : ++this.index;
        return variable;
    }

    public void begin() {
        this.stack.add(new VariableContext(this.index));
    }

    public void end() {
        this.index = this.stack.pop().getStartIndex();
    }

    public VariableEntry get(String identifier) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            VariableEntry entry = ((VariableContext)this.stack.get(i)).get(identifier);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    private void checkIdentifier(String identifier) throws ScriptCompileException {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            if (!((VariableContext)this.stack.get(i)).contains(identifier)) continue;
            throw new ScriptCompileException(String.format("Identifier %s is already declared.", identifier));
        }
    }
}

