/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler;

import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.VisibilityCheck;
import com.zergatul.cheatutils.scripting.compiler.BufferVisitor;
import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.MethodVisitorWrapper;
import com.zergatul.cheatutils.scripting.compiler.ScriptCompileException;
import com.zergatul.cheatutils.scripting.compiler.ScriptingClassLoader;
import com.zergatul.cheatutils.scripting.compiler.VariableEntry;
import com.zergatul.cheatutils.scripting.compiler.operations.BinaryOperation;
import com.zergatul.cheatutils.scripting.compiler.operations.ImplicitCast;
import com.zergatul.cheatutils.scripting.compiler.operations.UnaryOperation;
import com.zergatul.cheatutils.scripting.compiler.types.SArrayType;
import com.zergatul.cheatutils.scripting.compiler.types.SBoolean;
import com.zergatul.cheatutils.scripting.compiler.types.SFloatType;
import com.zergatul.cheatutils.scripting.compiler.types.SIntType;
import com.zergatul.cheatutils.scripting.compiler.types.SPrimitiveType;
import com.zergatul.cheatutils.scripting.compiler.types.SStringType;
import com.zergatul.cheatutils.scripting.compiler.types.SType;
import com.zergatul.cheatutils.scripting.compiler.types.SVoidType;
import com.zergatul.cheatutils.scripting.generated.ASTAdditiveExpression;
import com.zergatul.cheatutils.scripting.generated.ASTAllocationExpression;
import com.zergatul.cheatutils.scripting.generated.ASTArgumentList;
import com.zergatul.cheatutils.scripting.generated.ASTArguments;
import com.zergatul.cheatutils.scripting.generated.ASTAssignmentOperator;
import com.zergatul.cheatutils.scripting.generated.ASTBlock;
import com.zergatul.cheatutils.scripting.generated.ASTBlockStatement;
import com.zergatul.cheatutils.scripting.generated.ASTBooleanLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTBooleanType;
import com.zergatul.cheatutils.scripting.generated.ASTBreakStatement;
import com.zergatul.cheatutils.scripting.generated.ASTConditionalAndExpression;
import com.zergatul.cheatutils.scripting.generated.ASTConditionalExpression;
import com.zergatul.cheatutils.scripting.generated.ASTConditionalOrExpression;
import com.zergatul.cheatutils.scripting.generated.ASTContinueStatement;
import com.zergatul.cheatutils.scripting.generated.ASTDecrement;
import com.zergatul.cheatutils.scripting.generated.ASTEmptyStatement;
import com.zergatul.cheatutils.scripting.generated.ASTEqualityExpression;
import com.zergatul.cheatutils.scripting.generated.ASTExpression;
import com.zergatul.cheatutils.scripting.generated.ASTFloatType;
import com.zergatul.cheatutils.scripting.generated.ASTFloatingPointLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTForEachStatement;
import com.zergatul.cheatutils.scripting.generated.ASTForInit;
import com.zergatul.cheatutils.scripting.generated.ASTForStatement;
import com.zergatul.cheatutils.scripting.generated.ASTForUpdate;
import com.zergatul.cheatutils.scripting.generated.ASTIdentifier;
import com.zergatul.cheatutils.scripting.generated.ASTIfStatement;
import com.zergatul.cheatutils.scripting.generated.ASTIncrement;
import com.zergatul.cheatutils.scripting.generated.ASTInput;
import com.zergatul.cheatutils.scripting.generated.ASTIntType;
import com.zergatul.cheatutils.scripting.generated.ASTIntegerLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTLocalVariableDeclaration;
import com.zergatul.cheatutils.scripting.generated.ASTMultiplicativeExpression;
import com.zergatul.cheatutils.scripting.generated.ASTName;
import com.zergatul.cheatutils.scripting.generated.ASTNullLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTPreDecrementExpression;
import com.zergatul.cheatutils.scripting.generated.ASTPreIncrementExpression;
import com.zergatul.cheatutils.scripting.generated.ASTPrimaryExpression;
import com.zergatul.cheatutils.scripting.generated.ASTPrimaryPrefix;
import com.zergatul.cheatutils.scripting.generated.ASTPrimarySuffix;
import com.zergatul.cheatutils.scripting.generated.ASTPrimitiveType;
import com.zergatul.cheatutils.scripting.generated.ASTRelationalExpression;
import com.zergatul.cheatutils.scripting.generated.ASTStatement;
import com.zergatul.cheatutils.scripting.generated.ASTStatementExpression;
import com.zergatul.cheatutils.scripting.generated.ASTStatementExpressionList;
import com.zergatul.cheatutils.scripting.generated.ASTStringLiteral;
import com.zergatul.cheatutils.scripting.generated.ASTStringType;
import com.zergatul.cheatutils.scripting.generated.ASTType;
import com.zergatul.cheatutils.scripting.generated.ASTUnaryExpression;
import com.zergatul.cheatutils.scripting.generated.ASTUnaryExpressionNotPlusMinus;
import com.zergatul.cheatutils.scripting.generated.ASTVariableDeclarator;
import com.zergatul.cheatutils.scripting.generated.ASTVariableDeclaratorId;
import com.zergatul.cheatutils.scripting.generated.ASTVariableInitializer;
import com.zergatul.cheatutils.scripting.generated.Node;
import com.zergatul.cheatutils.scripting.generated.ParseException;
import com.zergatul.cheatutils.scripting.generated.ScriptingLanguage;
import com.zergatul.cheatutils.scripting.generated.SimpleNode;
import java.io.ByteArrayInputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ScriptingLanguageCompiler {
    private static AtomicInteger counter = new AtomicInteger(0);
    private static ScriptingClassLoader classLoader = new ScriptingClassLoader();
    private final Class<?> root;
    private final ApiType[] types;

    public ScriptingLanguageCompiler(Class<?> root, ApiType[] types) {
        this.root = root;
        this.types = types;
    }

    public Runnable compile(String program) throws ParseException, ScriptCompileException {
        Object instance;
        Constructor constructor;
        program = (String)program + "\r\n";
        ClassWriter writer = new ClassWriter(2);
        String name = "com/zergatul/scripting/dynamic/DynamicClass_" + counter.incrementAndGet();
        writer.visit(49, 1, name, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(Runnable.class)});
        MethodVisitor methodVisitor = writer.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        methodVisitor = writer.visitMethod(1, "run", "()V", null, null);
        methodVisitor.visitCode();
        ByteArrayInputStream stream = new ByteArrayInputStream(((String)program).getBytes(StandardCharsets.UTF_8));
        ScriptingLanguage parser = new ScriptingLanguage(stream);
        MethodVisitorWrapper visitor = new MethodVisitorWrapper(methodVisitor);
        visitor.getLoops().push(v -> {
            throw new ScriptCompileException("Continue statement without loop.");
        }, v -> {
            throw new ScriptCompileException("Break statement without loop.");
        });
        this.compile(parser.Input(), (CompilerMethodVisitor)visitor);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        writer.visitEnd();
        byte[] code = writer.toByteArray();
        Class dynamic = classLoader.defineClass(name.replace('/', '.'), code);
        try {
            constructor = dynamic.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptCompileException("Cannot find constructor for dynamic class.");
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ScriptCompileException("Cannot instantiate dynamic class.");
        }
        return (Runnable)instance;
    }

    private void compile(ASTInput input, CompilerMethodVisitor visitor) throws ScriptCompileException {
        for (int i = 0; i < input.jjtGetNumChildren(); ++i) {
            this.compile((ASTStatement)input.jjtGetChild(i), visitor);
        }
    }

    private void compile(ASTStatement statement, CompilerMethodVisitor visitor) throws ScriptCompileException {
        Node node = statement.jjtGetChild(0);
        if (node instanceof ASTEmptyStatement) {
            return;
        }
        if (node instanceof ASTStatementExpression) {
            ASTStatementExpression statementExpression = (ASTStatementExpression)node;
            this.compile(statementExpression, visitor);
            return;
        }
        if (node instanceof ASTBlock) {
            ASTBlock block = (ASTBlock)node;
            this.compile(block, visitor);
            return;
        }
        if (node instanceof ASTLocalVariableDeclaration) {
            ASTLocalVariableDeclaration localVariableDeclaration = (ASTLocalVariableDeclaration)node;
            this.compile(localVariableDeclaration, visitor);
            return;
        }
        if (node instanceof ASTIfStatement) {
            ASTIfStatement ifStatement = (ASTIfStatement)node;
            this.compile(ifStatement, visitor);
            return;
        }
        if (node instanceof ASTForStatement) {
            ASTForStatement forStatement = (ASTForStatement)node;
            this.compile(forStatement, visitor);
            return;
        }
        if (node instanceof ASTForEachStatement) {
            ASTForEachStatement forEachStatement = (ASTForEachStatement)node;
            this.compile(forEachStatement, visitor);
            return;
        }
        if (node instanceof ASTContinueStatement) {
            visitor.getLoops().compileContinue(visitor);
            return;
        }
        if (node instanceof ASTBreakStatement) {
            visitor.getLoops().compileBreak(visitor);
            return;
        }
        throw new ScriptCompileException("ASTStatement case not implemented: " + node.getClass().getName() + ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compile(ASTStatementExpression statementExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        Node node = statementExpression.jjtGetChild(0);
        if (node instanceof ASTPreIncrementExpression) {
            ASTPreIncrementExpression preIncrementExpression = (ASTPreIncrementExpression)node;
            throw new ScriptCompileException("Not implemented");
        }
        if (node instanceof ASTPreDecrementExpression) {
            ASTPreDecrementExpression preDecrementExpression = (ASTPreDecrementExpression)node;
            throw new ScriptCompileException("Not implemented");
        }
        if (!(node instanceof ASTPrimaryExpression)) throw new ScriptCompileException("ASTStatementExpression case not implemented: " + node.getClass().getName() + ".");
        ASTPrimaryExpression primary = (ASTPrimaryExpression)node;
        if (statementExpression.jjtGetNumChildren() == 1) {
            SType type = this.compile(primary, visitor);
            if (type == SVoidType.instance) return;
            visitor.visitInsn(87);
            return;
        }
        if (statementExpression.jjtGetNumChildren() == 2) {
            SType type = this.compile(primary, visitor);
            if (type != SIntType.instance) {
                throw new ScriptCompileException("Operators ++/-- can only be applied to int.");
            }
            if (statementExpression.jjtGetChild(1) instanceof ASTIncrement) {
                visitor.visitInsn(4);
                visitor.visitInsn(96);
            } else {
                if (!(statementExpression.jjtGetChild(1) instanceof ASTDecrement)) throw new ScriptCompileException("ASTStatementExpression: unknown post operator.");
                visitor.visitInsn(4);
                visitor.visitInsn(100);
            }
            ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)primary.jjtGetChild(0);
            Node node2 = primaryPrefix.jjtGetChild(0);
            if (!(node2 instanceof ASTName)) throw new ScriptCompileException("ASTAssignStatement -> ASTPrimaryPrefix is not ASTName.");
            ASTName name = (ASTName)node2;
            if (name.jjtGetNumChildren() > 1) {
                throw new ScriptCompileException("Assignment: cannot assign field.");
            }
            ASTIdentifier identifier = (ASTIdentifier)name.jjtGetChild(0);
            VariableEntry variable = visitor.getContextStack().get((String)identifier.jjtGetValue());
            if (variable == null) {
                throw new ScriptCompileException(String.format("Variable %s is not declared.", identifier.jjtGetValue()));
            }
            if (primary.jjtGetNumChildren() == 1) {
                visitor.visitVarInsn(variable.type().getStoreInst(), variable.index());
                return;
            } else {
                ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)primary.jjtGetChild(1);
                Node node3 = primarySuffix.jjtGetChild(0);
                if (!(node3 instanceof ASTExpression)) throw new ScriptCompileException("ASTAssignStatement -> ASTPrimarySuffix is not ASTExpression.");
                ASTExpression indexExpression = (ASTExpression)node3;
                SType sType = variable.type();
                if (!(sType instanceof SArrayType)) throw new ScriptCompileException(String.format("Variable %s is not array.", identifier.jjtGetValue()));
                SArrayType arrayType = (SArrayType)sType;
                visitor.visitVarInsn(variable.type().getLoadInst(), variable.index());
                visitor.visitInsn(95);
                SType indexType = this.compile(indexExpression, visitor);
                visitor.visitInsn(95);
                if (indexType != SIntType.instance) {
                    throw new ScriptCompileException("Array index can be only integer.");
                }
                visitor.visitInsn(arrayType.getElementsType().getArrayStoreInst());
            }
            return;
        }
        if (statementExpression.jjtGetNumChildren() != 3) throw new ScriptCompileException("ASTStatementExpression/ASTPrimaryExpression children > 3 not implemented");
        ASTAssignmentOperator assignmentOperator = (ASTAssignmentOperator)statementExpression.jjtGetChild(1);
        ASTExpression expression = (ASTExpression)statementExpression.jjtGetChild(2);
        this.compileAssignment(primary, assignmentOperator, expression, visitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileAssignment(ASTPrimaryExpression primary, ASTAssignmentOperator operator, ASTExpression expression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)primary.jjtGetChild(0);
        Node node = primaryPrefix.jjtGetChild(0);
        if (!(node instanceof ASTName)) throw new ScriptCompileException("ASTAssignStatement -> ASTPrimaryPrefix is not ASTName.");
        ASTName name = (ASTName)node;
        if (name.jjtGetNumChildren() > 1) {
            throw new ScriptCompileException("Assignment: cannot assign field.");
        }
        ASTIdentifier identifier = (ASTIdentifier)name.jjtGetChild(0);
        VariableEntry variable = visitor.getContextStack().get((String)identifier.jjtGetValue());
        if (variable == null) {
            throw new ScriptCompileException(String.format("Variable %s is not declared.", identifier.jjtGetValue()));
        }
        if (primary.jjtGetNumChildren() == 1) {
            SType rightType = this.compile(expression, visitor);
            if (!rightType.equals(variable.type())) {
                throw new ScriptCompileException(String.format("Attempt to assign %s to variable %s of type %s.", rightType, identifier.jjtGetValue(), variable.type()));
            }
            visitor.visitVarInsn(variable.type().getStoreInst(), variable.index());
            return;
        } else {
            ASTPrimarySuffix primarySuffix = (ASTPrimarySuffix)primary.jjtGetChild(1);
            Node node2 = primarySuffix.jjtGetChild(0);
            if (!(node2 instanceof ASTExpression)) throw new ScriptCompileException("ASTAssignStatement -> ASTPrimarySuffix is not ASTExpression.");
            ASTExpression indexExpression = (ASTExpression)node2;
            SType sType = variable.type();
            if (!(sType instanceof SArrayType)) throw new ScriptCompileException(String.format("Variable %s is not array.", identifier.jjtGetValue()));
            SArrayType arrayType = (SArrayType)sType;
            visitor.visitVarInsn(variable.type().getLoadInst(), variable.index());
            SType indexType = this.compile(indexExpression, visitor);
            if (indexType != SIntType.instance) {
                throw new ScriptCompileException("Array index can be only integer.");
            }
            SType rightType = this.compile(expression, visitor);
            if (!arrayType.getElementsType().equals(rightType)) {
                throw new ScriptCompileException("Array element type doesn't match.");
            }
            visitor.visitInsn(arrayType.getElementsType().getArrayStoreInst());
        }
    }

    private void compile(ASTBlock block, CompilerMethodVisitor visitor) throws ScriptCompileException {
        visitor.getContextStack().begin();
        int numChildren = block.jjtGetNumChildren();
        for (int i = 0; i < numChildren; ++i) {
            this.compile((ASTBlockStatement)block.jjtGetChild(i), visitor);
        }
        visitor.getContextStack().end();
    }

    private SType compile(ASTPrimaryExpression primaryExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)primaryExpression.jjtGetChild(0);
        Node prefixNode = prefix.jjtGetChild(0);
        if (primaryExpression.jjtGetNumChildren() == 1) {
            if (prefixNode instanceof ASTLiteral) {
                ASTLiteral literal = (ASTLiteral)prefixNode;
                return this.compile(literal, visitor);
            }
            if (prefixNode instanceof ASTName) {
                ASTName name = (ASTName)prefixNode;
                if (name.jjtGetNumChildren() == 1) {
                    ASTIdentifier identifier = (ASTIdentifier)name.jjtGetChild(0);
                    VariableEntry variable = visitor.getContextStack().get((String)identifier.jjtGetValue());
                    if (variable == null) {
                        throw new ScriptCompileException(String.format("Variable %s is not declared.", identifier.jjtGetValue()));
                    }
                    visitor.visitVarInsn(variable.type().getLoadInst(), variable.index());
                    return variable.type();
                }
                if (name.jjtGetNumChildren() == 2) {
                    String identifier1 = (String)((ASTIdentifier)name.jjtGetChild(0)).jjtGetValue();
                    String identifier2 = (String)((ASTIdentifier)name.jjtGetChild(1)).jjtGetValue();
                    VariableEntry variable = visitor.getContextStack().get(identifier1);
                    if (variable == null) {
                        throw new ScriptCompileException(String.format("Variable %s is not declared.", identifier1));
                    }
                    visitor.visitVarInsn(variable.type().getLoadInst(), variable.index());
                    SType type = variable.type().compileGetField(identifier2, visitor);
                    if (type == null) {
                        throw new ScriptCompileException(String.format("Cannot find field %s for variable %s.", identifier2, identifier1));
                    }
                    return type;
                }
                throw new ScriptCompileException(String.format("ASTName: %s num children.", name.jjtGetNumChildren()));
            }
            if (prefixNode instanceof ASTExpression) {
                ASTExpression expression = (ASTExpression)prefixNode;
                return this.compile(expression, visitor);
            }
            if (prefixNode instanceof ASTAllocationExpression) {
                ASTAllocationExpression allocationExpression = (ASTAllocationExpression)prefixNode;
                return this.compile(allocationExpression, visitor);
            }
            throw new ScriptCompileException("ASTPrimaryExpression(1) case not implemented: " + prefixNode.getClass().getName() + ".");
        }
        ASTPrimarySuffix suffix = (ASTPrimarySuffix)primaryExpression.jjtGetChild(1);
        if (prefixNode instanceof ASTLiteral) {
            throw new ScriptCompileException("ASTLiteral cannot have PrimarySuffix");
        }
        if (prefixNode instanceof ASTName) {
            ASTName name = (ASTName)prefixNode;
            Node variable = suffix.jjtGetChild(0);
            if (variable instanceof ASTArguments) {
                ASTArguments arguments = (ASTArguments)variable;
                return this.compile(name, arguments, visitor);
            }
            variable = suffix.jjtGetChild(0);
            if (variable instanceof ASTExpression) {
                ASTExpression expression = (ASTExpression)variable;
                if (name.jjtGetNumChildren() > 1) {
                    throw new ScriptCompileException("ASTPrimaryExpression cannot reference fields.");
                }
                ASTIdentifier identifier = (ASTIdentifier)name.jjtGetChild(0);
                VariableEntry variable2 = visitor.getContextStack().get((String)identifier.jjtGetValue());
                if (variable2 == null) {
                    throw new ScriptCompileException(String.format("Variable %s is not declared.", identifier.jjtGetValue()));
                }
                SType sType = variable2.type();
                if (sType instanceof SArrayType) {
                    SArrayType arrayType = (SArrayType)sType;
                    visitor.visitVarInsn(variable2.type().getLoadInst(), variable2.index());
                    SType indexType = this.compile(expression, visitor);
                    if (indexType != SIntType.instance) {
                        throw new ScriptCompileException("Array index can only be integer.");
                    }
                    visitor.visitInsn(arrayType.getElementsType().getArrayLoadInst());
                    return arrayType.getElementsType();
                }
                throw new ScriptCompileException(String.format("Variable %s is not array.", identifier.jjtGetValue()));
            }
            throw new ScriptCompileException("ASTPrimaryExpression(2) -> ASTName - unexpected case");
        }
        if (prefixNode instanceof ASTExpression) {
            throw new ScriptCompileException("ASTExpression cannot have PrimarySuffix");
        }
        throw new ScriptCompileException("ASTPrimaryExpression(2) case not implemented: " + prefixNode.getClass().getName() + ".");
    }

    private SType compile(ASTName name, ASTArguments arguments, CompilerMethodVisitor visitor) throws ScriptCompileException {
        BufferVisitor[] methodArgumentVisitors;
        SType[] methodArgumentTypes;
        int argsLength;
        Field field;
        if (name.jjtGetNumChildren() < 2) {
            throw new ScriptCompileException("Method call node should have at least 2 names.");
        }
        String fieldName = (String)((SimpleNode)name.jjtGetChild(0)).jjtGetValue();
        try {
            field = this.root.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ScriptCompileException("Cannot find field \"" + fieldName + "\".");
        }
        visitor.visitFieldInsn(178, Type.getInternalName(this.root), field.getName(), Type.getDescriptor(field.getType()));
        Class<?> currentInstance = field.getType();
        for (int i = 1; i < name.jjtGetNumChildren() - 1; ++i) {
            fieldName = (String)((SimpleNode)name.jjtGetChild(i)).jjtGetValue();
            try {
                field = currentInstance.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new ScriptCompileException("Cannot find field \"" + fieldName + "\".");
            }
            visitor.visitFieldInsn(180, Type.getInternalName(currentInstance), field.getName(), Type.getDescriptor(field.getType()));
            currentInstance = field.getType();
        }
        if (arguments.jjtGetNumChildren() == 0) {
            argsLength = 0;
            methodArgumentTypes = new SType[]{};
            methodArgumentVisitors = new BufferVisitor[]{};
        } else {
            ASTArgumentList argumentList = (ASTArgumentList)arguments.jjtGetChild(0);
            argsLength = argumentList.jjtGetNumChildren();
            methodArgumentTypes = new SType[argsLength];
            methodArgumentVisitors = new BufferVisitor[argsLength];
            for (int i = 0; i < argsLength; ++i) {
                methodArgumentVisitors[i] = new BufferVisitor(visitor.getContextStack());
                methodArgumentTypes[i] = this.compile((ASTExpression)argumentList.jjtGetChild(i), (CompilerMethodVisitor)methodArgumentVisitors[i]);
            }
        }
        String methodName = (String)((SimpleNode)name.jjtGetChild(name.jjtGetNumChildren() - 1)).jjtGetValue();
        Method method = this.findMethod(field, methodName, methodArgumentTypes, methodArgumentVisitors);
        if (method == null) {
            throw new ScriptCompileException("Cannot find method \"" + methodName + "\".");
        }
        for (int i = 0; i < argsLength; ++i) {
            methodArgumentVisitors[i].releaseBuffer(visitor);
        }
        visitor.visitMethodInsn(182, Type.getInternalName(method.getDeclaringClass()), method.getName(), Type.getMethodDescriptor((Method)method), false);
        return SType.fromJavaClass(method.getReturnType());
    }

    private void compile(ASTBlockStatement blockStatement, CompilerMethodVisitor visitor) throws ScriptCompileException {
        for (int i = 0; i < blockStatement.jjtGetNumChildren(); ++i) {
            Node node = blockStatement.jjtGetChild(i);
            if (!(node instanceof ASTStatement)) {
                throw new ScriptCompileException("Unexpected type in ASTBlockStatement.");
            }
            ASTStatement statement = (ASTStatement)node;
            this.compile(statement, visitor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VariableEntry compile(ASTLocalVariableDeclaration localVariableDeclaration, CompilerMethodVisitor visitor) throws ScriptCompileException {
        ASTType astType = (ASTType)localVariableDeclaration.jjtGetChild(0);
        ASTVariableDeclarator variableDeclarator = (ASTVariableDeclarator)localVariableDeclaration.jjtGetChild(1);
        ASTVariableDeclaratorId variableDeclaratorId = (ASTVariableDeclaratorId)variableDeclarator.jjtGetChild(0);
        ASTIdentifier identifier = (ASTIdentifier)variableDeclaratorId.jjtGetChild(0);
        ASTVariableInitializer initializer = null;
        if (variableDeclarator.jjtGetNumChildren() > 1) {
            initializer = (ASTVariableInitializer)variableDeclarator.jjtGetChild(1);
        }
        SType type = this.parseType(astType);
        if (initializer != null) {
            SType returnType = this.compile((ASTExpression)initializer.jjtGetChild(0), visitor);
            if (!returnType.equals(type)) {
                UnaryOperation operation = ImplicitCast.get(returnType, type);
                if (operation == null) throw new ScriptCompileException(String.format("Variable type %s assigned to expression of type %s.", type, returnType));
                operation.apply(visitor);
            }
        } else {
            type.storeDefaultValue(visitor);
        }
        String variableName = (String)identifier.jjtGetValue();
        if (Arrays.stream(this.root.getDeclaredFields()).anyMatch(f -> f.getName().equals(variableName))) {
            throw new ScriptCompileException(String.format("Cannot declare variable %s because API class with the same name exists.", variableName));
        }
        VariableEntry variable = visitor.getContextStack().add(variableName, type);
        visitor.visitVarInsn(variable.type().getStoreInst(), variable.index());
        return variable;
    }

    private SType compile(ASTAllocationExpression allocationExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        ASTType astType = (ASTType)allocationExpression.jjtGetChild(0);
        ASTExpression expression = (ASTExpression)allocationExpression.jjtGetChild(1);
        SType dimensionsType = this.compile(expression, visitor);
        if (dimensionsType != SIntType.instance) {
            throw new ScriptCompileException("Array dimensions must be integer");
        }
        SType type = this.parseType(astType);
        if (type.isReference()) {
            visitor.visitTypeInsn(189, Type.getInternalName(type.getJavaClass()));
        } else {
            visitor.visitIntInsn(188, ((SPrimitiveType)type).getArrayTypeInst());
        }
        return new SArrayType(type);
    }

    private void compile(ASTIfStatement ifStatement, CompilerMethodVisitor visitor) throws ScriptCompileException {
        int numChildren = ifStatement.jjtGetNumChildren();
        if (numChildren < 2) {
            throw new ScriptCompileException("ASTIfStatement invalid children count.");
        }
        ASTExpression ifExpr = (ASTExpression)ifStatement.jjtGetChild(0);
        ASTStatement thenStmt = (ASTStatement)ifStatement.jjtGetChild(1);
        ASTStatement elseStmt = numChildren > 2 ? (ASTStatement)ifStatement.jjtGetChild(2) : null;
        SType type = this.compile(ifExpr, visitor);
        if (type != SBoolean.instance) {
            throw new ScriptCompileException("Expression inside \"if\" statement should return boolean.");
        }
        if (elseStmt == null) {
            Label endLabel = new Label();
            visitor.visitJumpInsn(153, endLabel);
            this.compile(thenStmt, visitor);
            visitor.visitLabel(endLabel);
        } else {
            Label elseLabel = new Label();
            visitor.visitJumpInsn(153, elseLabel);
            this.compile(thenStmt, visitor);
            Label endLabel = new Label();
            visitor.visitJumpInsn(167, endLabel);
            visitor.visitLabel(elseLabel);
            this.compile(elseStmt, visitor);
            visitor.visitLabel(endLabel);
        }
    }

    private void compile(ASTForStatement forStatement, CompilerMethodVisitor visitor) throws ScriptCompileException {
        SimpleNode node;
        visitor.getContextStack().begin();
        ASTForInit init = null;
        SimpleNode exit = null;
        SimpleNode update = null;
        int index = 0;
        Node node2 = forStatement.jjtGetChild(index);
        if (node2 instanceof ASTForInit) {
            node = (ASTForInit)node2;
            init = node;
            ++index;
        }
        if ((node2 = forStatement.jjtGetChild(index)) instanceof ASTExpression) {
            node = (ASTExpression)node2;
            exit = node;
            ++index;
        }
        if ((node2 = forStatement.jjtGetChild(index)) instanceof ASTForUpdate) {
            update = node = (ASTForUpdate)node2;
            ++index;
        }
        ASTStatement body = (ASTStatement)forStatement.jjtGetChild(index);
        Label begin = new Label();
        Label continueLabel = new Label();
        Label end = new Label();
        if (init != null) {
            Node node3 = init.jjtGetChild(0);
            if (node3 instanceof ASTLocalVariableDeclaration) {
                ASTLocalVariableDeclaration localVariableDeclaration = (ASTLocalVariableDeclaration)node3;
                this.compile(localVariableDeclaration, visitor);
            } else {
                node3 = init.jjtGetChild(0);
                if (node3 instanceof ASTStatementExpressionList) {
                    ASTStatementExpressionList statementExpressionList = (ASTStatementExpressionList)node3;
                    this.compile(statementExpressionList, visitor);
                } else {
                    throw new ScriptCompileException(String.format("ForInit unexpected child: %s", init.jjtGetChild(0).getClass().getSimpleName()));
                }
            }
        }
        visitor.visitLabel(begin);
        if (exit != null) {
            SType type = this.compile((ASTExpression)exit, visitor);
            if (type != SBoolean.instance) {
                throw new ScriptCompileException("For loop exit expression must return boolean.");
            }
            visitor.visitJumpInsn(153, end);
        }
        visitor.getLoops().push(v -> v.visitJumpInsn(167, continueLabel), v -> v.visitJumpInsn(167, end));
        this.compile(body, visitor);
        visitor.getLoops().pop();
        visitor.visitLabel(continueLabel);
        if (update != null) {
            this.compile((ASTStatementExpressionList)update.jjtGetChild(0), visitor);
        }
        visitor.visitJumpInsn(167, begin);
        visitor.visitLabel(end);
        visitor.getContextStack().end();
    }

    private void compile(ASTForEachStatement forEachStatement, CompilerMethodVisitor visitor) throws ScriptCompileException {
        visitor.getContextStack().begin();
        ASTLocalVariableDeclaration variable = (ASTLocalVariableDeclaration)forEachStatement.jjtGetChild(0);
        ASTExpression iterable = (ASTExpression)forEachStatement.jjtGetChild(1);
        ASTStatement body = (ASTStatement)forEachStatement.jjtGetChild(2);
        VariableEntry loopVar = this.compile(variable, visitor);
        VariableEntry indexVar = visitor.getContextStack().add(null, SIntType.instance);
        Label begin = new Label();
        Label continueLabel = new Label();
        Label end = new Label();
        visitor.visitInsn(3);
        visitor.visitVarInsn(indexVar.type().getStoreInst(), indexVar.index());
        SType object = this.compile(iterable, visitor);
        if (!(object instanceof SArrayType)) {
            throw new ScriptCompileException("foreach can only loop over array.");
        }
        SArrayType arrayType = (SArrayType)object;
        VariableEntry arrayVar = visitor.getContextStack().add(null, arrayType);
        if (!arrayType.getElementsType().equals(loopVar.type())) {
            throw new ScriptCompileException("foreach loop variable type mismatch.");
        }
        visitor.visitVarInsn(arrayType.getStoreInst(), arrayVar.index());
        visitor.visitLabel(begin);
        visitor.visitVarInsn(indexVar.type().getLoadInst(), indexVar.index());
        visitor.visitVarInsn(arrayVar.type().getLoadInst(), arrayVar.index());
        visitor.visitInsn(190);
        visitor.visitJumpInsn(162, end);
        visitor.visitVarInsn(arrayVar.type().getLoadInst(), arrayVar.index());
        visitor.visitVarInsn(indexVar.type().getLoadInst(), indexVar.index());
        visitor.visitInsn(loopVar.type().getArrayLoadInst());
        visitor.visitVarInsn(loopVar.type().getStoreInst(), loopVar.index());
        visitor.getLoops().push(v -> v.visitJumpInsn(167, continueLabel), v -> v.visitJumpInsn(167, end));
        this.compile(body, visitor);
        visitor.getLoops().pop();
        visitor.visitLabel(continueLabel);
        visitor.visitIincInsn(indexVar.index(), 1);
        visitor.visitJumpInsn(167, begin);
        visitor.visitLabel(end);
        visitor.getContextStack().end();
    }

    private void compile(ASTStatementExpressionList list, CompilerMethodVisitor visitor) throws ScriptCompileException {
        for (int i = 0; i < list.jjtGetNumChildren(); ++i) {
            this.compile((ASTStatementExpression)list.jjtGetChild(i), visitor);
        }
    }

    private SType compile(ASTExpression expression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        if (expression.jjtGetNumChildren() != 1) {
            throw new ScriptCompileException("ASTExpression invalid children count.");
        }
        Node node = expression.jjtGetChild(0);
        if (node instanceof ASTConditionalExpression) {
            ASTConditionalExpression conditionalExpression = (ASTConditionalExpression)node;
            return this.compile(conditionalExpression, visitor);
        }
        throw new ScriptCompileException("ASTExpression case not implemented: " + node.getClass().getName() + ".");
    }

    private SType compile(ASTConditionalExpression conditionalExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        if (conditionalExpression.jjtGetNumChildren() == 1) {
            Node node = conditionalExpression.jjtGetChild(0);
            if (node instanceof ASTConditionalOrExpression) {
                ASTConditionalOrExpression conditionalOrExpression = (ASTConditionalOrExpression)node;
                return this.compileOrExpression(conditionalOrExpression, visitor);
            }
            throw new ScriptCompileException("ASTConditionalExpression case not implemented: " + node.getClass().getName() + ".");
        }
        if (conditionalExpression.jjtGetNumChildren() == 3) {
            ASTConditionalOrExpression condition = (ASTConditionalOrExpression)conditionalExpression.jjtGetChild(0);
            ASTExpression expression1 = (ASTExpression)conditionalExpression.jjtGetChild(1);
            ASTConditionalExpression expression2 = (ASTConditionalExpression)conditionalExpression.jjtGetChild(2);
            SType conditionReturnType = this.compileOrExpression(condition, visitor);
            if (conditionReturnType != SBoolean.instance) {
                throw new ScriptCompileException("ASTConditionalExpression should return boolean.");
            }
            Label elseLabel = new Label();
            visitor.visitJumpInsn(153, elseLabel);
            SType expression1ReturnType = this.compile(expression1, visitor);
            Label endLabel = new Label();
            visitor.visitJumpInsn(167, endLabel);
            visitor.visitLabel(elseLabel);
            SType expression2ReturnType = this.compile(expression2, visitor);
            visitor.visitLabel(endLabel);
            if (expression1ReturnType != expression2ReturnType) {
                throw new ScriptCompileException("ASTConditionalExpression return types don't match.");
            }
            return expression1ReturnType;
        }
        throw new ScriptCompileException("ASTConditionalExpression invalid children count.");
    }

    private SType compileOrExpression(ASTConditionalOrExpression conditionalOrExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(conditionalOrExpression, visitor, this::compileAndExpression);
    }

    private SType compileAndExpression(ASTConditionalAndExpression conditionalAndExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(conditionalAndExpression, visitor, this::compileEqualityExpression);
    }

    private SType compileEqualityExpression(ASTEqualityExpression equalityExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(equalityExpression, visitor, this::compileRelationalExpression);
    }

    private SType compileRelationalExpression(ASTRelationalExpression relationalExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(relationalExpression, visitor, this::compileAdditiveExpression);
    }

    private SType compileAdditiveExpression(ASTAdditiveExpression additiveExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(additiveExpression, visitor, this::compileMultiplicativeExpression);
    }

    private SType compileMultiplicativeExpression(ASTMultiplicativeExpression multiplicativeExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        return this.binaryOperatorCompile(multiplicativeExpression, visitor, this::compileUnaryExpression);
    }

    private SType compileUnaryExpression(ASTUnaryExpression unaryExpression, CompilerMethodVisitor visitor) throws ScriptCompileException {
        int numChildren = unaryExpression.jjtGetNumChildren();
        if (numChildren == 1) {
            return this.compileUnaryExpressionNotPlusMinus((ASTUnaryExpressionNotPlusMinus)unaryExpression.jjtGetChild(0), visitor);
        }
        if (numChildren == 2) {
            Node operator = unaryExpression.jjtGetChild(0);
            SType type = this.compileUnaryExpression((ASTUnaryExpression)unaryExpression.jjtGetChild(1), visitor);
            UnaryOperation operation = type.unary(operator);
            if (operation != null) {
                operation.apply(visitor);
                return operation.getType();
            }
            throw new ScriptCompileException(String.format("ASTUnaryExpression: cannot process type %s. Operator: %s.", type.getClass().getSimpleName(), operator.getClass().getSimpleName()));
        }
        throw new ScriptCompileException("ASTUnaryExpression invalid children count.");
    }

    private SType compileUnaryExpressionNotPlusMinus(ASTUnaryExpressionNotPlusMinus unaryExpressionNotPlusMinus, CompilerMethodVisitor visitor) throws ScriptCompileException {
        int numChildren = unaryExpressionNotPlusMinus.jjtGetNumChildren();
        if (numChildren == 1) {
            return this.compile((ASTPrimaryExpression)unaryExpressionNotPlusMinus.jjtGetChild(0), visitor);
        }
        if (numChildren == 2) {
            Node operator = unaryExpressionNotPlusMinus.jjtGetChild(0);
            SType type = this.compileUnaryExpression((ASTUnaryExpression)unaryExpressionNotPlusMinus.jjtGetChild(1), visitor);
            UnaryOperation operation = type.unary(operator);
            if (operation != null) {
                operation.apply(visitor);
                return operation.getType();
            }
            throw new ScriptCompileException(String.format("ASTUnaryExpressionNotPlusMinus: cannot process type %s. Operator: %s.", type.getClass().getSimpleName(), operator.getClass().getSimpleName()));
        }
        throw new ScriptCompileException("ASTUnaryExpressionNotPlusMinus invalid children count.");
    }

    private SType compile(ASTLiteral literal, CompilerMethodVisitor visitor) throws ScriptCompileException {
        if (literal.jjtGetNumChildren() != 1) {
            throw new ScriptCompileException("ASTLiteral invalid children count.");
        }
        Node node = literal.jjtGetChild(0);
        if (node instanceof ASTStringLiteral) {
            ASTStringLiteral stringLiteral = (ASTStringLiteral)node;
            String value = this.parseString((String)stringLiteral.jjtGetValue());
            visitor.visitLdcInsn(value);
            return SStringType.instance;
        }
        if (node instanceof ASTBooleanLiteral) {
            ASTBooleanLiteral booleanLiteral = (ASTBooleanLiteral)node;
            boolean value = (Boolean)booleanLiteral.jjtGetValue();
            visitor.visitIntInsn(16, value ? 1 : 0);
            return SBoolean.instance;
        }
        if (node instanceof ASTIntegerLiteral) {
            ASTIntegerLiteral integerLiteral = (ASTIntegerLiteral)node;
            int value = Integer.parseInt((String)integerLiteral.jjtGetValue());
            visitor.visitLdcInsn(value);
            return SIntType.instance;
        }
        if (node instanceof ASTFloatingPointLiteral) {
            ASTFloatingPointLiteral floatingPointLiteral = (ASTFloatingPointLiteral)node;
            double value = Double.parseDouble((String)floatingPointLiteral.jjtGetValue());
            visitor.visitLdcInsn(value);
            return SFloatType.instance;
        }
        if (node instanceof ASTNullLiteral) {
            throw new ScriptCompileException("Cannot use null.");
        }
        throw new ScriptCompileException("ASTLiteral case not implemented: " + node.getClass().getName() + ".");
    }

    private <T1 extends SimpleNode, T2 extends SimpleNode> SType binaryOperatorCompile(T1 expression, CompilerMethodVisitor visitor, CompileNodeFunction<T2> childCompile) throws ScriptCompileException {
        SimpleNode child = (SimpleNode)expression.jjtGetChild(0);
        SType typeLeft = childCompile.apply(child, visitor);
        int numChildren = expression.jjtGetNumChildren();
        if (numChildren == 1) {
            return typeLeft;
        }
        for (int i = 1; i < numChildren; i += 2) {
            Node operator = expression.jjtGetChild(i);
            BufferVisitor bufferVisitor = new BufferVisitor(visitor.getContextStack());
            SType typeRight = childCompile.apply((SimpleNode)expression.jjtGetChild(i + 1), bufferVisitor);
            BinaryOperation operation = typeLeft.binary(operator, typeRight);
            if (operation == null) {
                throw new ScriptCompileException(String.format("%s: cannot process types %s and %s. Operator: %s.", expression.getClass().getSimpleName(), typeLeft.getClass().getSimpleName(), typeRight.getClass().getSimpleName(), operator.getClass().getSimpleName()));
            }
            operation.apply(visitor, bufferVisitor);
            typeLeft = operation.getType();
        }
        return typeLeft;
    }

    private Method findMethod(Field field, String name, SType[] argumentTypes, BufferVisitor[] argumentVisitors) throws ScriptCompileException {
        FindMethodResult methodResult = null;
        for (Method m : field.getType().getMethods()) {
            Parameter[] parameters;
            if (m.getDeclaringClass() == Object.class || !m.getName().equals(name) || !VisibilityCheck.isOk(m, this.types) || (parameters = m.getParameters()).length != argumentTypes.length) continue;
            BufferVisitor[] casts = new BufferVisitor[parameters.length];
            boolean ok = true;
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> scriptParameterClass;
                Class<?> methodParameterClass = parameters[i].getType();
                if (methodParameterClass == (scriptParameterClass = argumentTypes[i].getJavaClass())) continue;
                UnaryOperation operation = ImplicitCast.get(SType.fromJavaClass(scriptParameterClass), SType.fromJavaClass(methodParameterClass));
                if (operation != null) {
                    casts[i] = new BufferVisitor(null);
                    operation.apply(casts[i]);
                    continue;
                }
                ok = false;
                break;
            }
            if (!ok) continue;
            FindMethodResult result = new FindMethodResult(m, (int)Arrays.stream(casts).filter(Objects::nonNull).count(), casts);
            if (methodResult != null && methodResult.count <= result.count) continue;
            methodResult = result;
        }
        if (methodResult == null) {
            return null;
        }
        for (int i = 0; i < argumentVisitors.length; ++i) {
            if (methodResult.casts[i] == null) continue;
            methodResult.casts[i].releaseBuffer(argumentVisitors[i]);
        }
        return methodResult.method;
    }

    private String parseString(String value) throws ScriptCompileException {
        value = value.substring(1, value.length() - 1);
        block10: for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != '\\') continue;
            char next = value.charAt(i + 1);
            switch (next) {
                case 'n': {
                    value = this.replace(value, i, 2, "\n");
                    continue block10;
                }
                case 'r': {
                    value = this.replace(value, i, 2, "\r");
                    continue block10;
                }
                case 't': {
                    value = this.replace(value, i, 2, "\t");
                    continue block10;
                }
                case 'b': {
                    value = this.replace(value, i, 2, "\b");
                    continue block10;
                }
                case 'f': {
                    value = this.replace(value, i, 2, "\f");
                    continue block10;
                }
                case '\\': {
                    value = this.replace(value, i, 2, "\\");
                    continue block10;
                }
                case '\"': {
                    value = this.replace(value, i, 2, "\"");
                    continue block10;
                }
                case '\'': {
                    value = this.replace(value, i, 2, "'");
                    continue block10;
                }
                default: {
                    throw new ScriptCompileException("Cannot parse string literal.");
                }
            }
        }
        return value;
    }

    private String replace(String value, int from, int length, String replacement) {
        return value.substring(0, from) + replacement + value.substring(from + length);
    }

    private SType parseType(ASTType typeNode) throws ScriptCompileException {
        SType type = this.parsePrimitiveType((ASTPrimitiveType)typeNode.jjtGetChild(0));
        for (int i = 1; i < typeNode.jjtGetNumChildren(); i += 2) {
            type = new SArrayType(type);
        }
        return type;
    }

    private SPrimitiveType parsePrimitiveType(ASTPrimitiveType primitiveType) throws ScriptCompileException {
        if (primitiveType.jjtGetChild(0) instanceof ASTBooleanType) {
            return SBoolean.instance;
        }
        if (primitiveType.jjtGetChild(0) instanceof ASTIntType) {
            return SIntType.instance;
        }
        if (primitiveType.jjtGetChild(0) instanceof ASTFloatType) {
            return SFloatType.instance;
        }
        if (primitiveType.jjtGetChild(0) instanceof ASTStringType) {
            return SStringType.instance;
        }
        throw new ScriptCompileException(String.format("Unexpected primitive type %s.", primitiveType.getClass().getSimpleName()));
    }

    private void printTopStackInt(CompilerMethodVisitor visitor) throws ScriptCompileException {
        Field field;
        Method method;
        try {
            method = PrintStream.class.getDeclaredMethod("println", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new ScriptCompileException("printTopStackInt cannot find PrintStream.println(int) method.");
        }
        try {
            field = System.class.getDeclaredField("out");
        }
        catch (NoSuchFieldException e) {
            throw new ScriptCompileException("printTopStackInt cannot find System.out field");
        }
        visitor.visitInsn(89);
        visitor.visitFieldInsn(178, Type.getInternalName(System.class), field.getName(), Type.getDescriptor(field.getType()));
        visitor.visitInsn(95);
        visitor.visitMethodInsn(182, Type.getInternalName(PrintStream.class), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    @FunctionalInterface
    private static interface CompileNodeFunction<T1> {
        public SType apply(T1 var1, CompilerMethodVisitor var2) throws ScriptCompileException;
    }

    private record FindMethodResult(Method method, int count, BufferVisitor[] casts) {
    }
}

