/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler;

import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.LoopContextStack;
import com.zergatul.cheatutils.scripting.compiler.VariableContextStack;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class MethodVisitorWrapper
extends CompilerMethodVisitor {
    private final MethodVisitor visitor;
    private final VariableContextStack contexts;
    private final LoopContextStack loops;

    public MethodVisitorWrapper(MethodVisitor visitor) {
        this.visitor = visitor;
        this.contexts = new VariableContextStack();
        this.loops = new LoopContextStack();
    }

    @Override
    public VariableContextStack getContextStack() {
        return this.contexts;
    }

    @Override
    public LoopContextStack getLoops() {
        return this.loops;
    }

    @Override
    public void visitInsn(int opcode) {
        this.visitor.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.visitor.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.visitor.visitFieldInsn(opcode, owner, name, descriptor);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.visitor.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.visitor.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.visitor.visitLdcInsn(value);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.visitor.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    @Override
    public void visitTypeInsn(int opcode, String descriptor) {
        this.visitor.visitTypeInsn(opcode, descriptor);
    }

    @Override
    public void visitVarInsn(int opcode, int index) {
        this.visitor.visitVarInsn(opcode, index);
    }

    @Override
    public void visitIincInsn(int varIndex, int increment) {
        this.visitor.visitIincInsn(varIndex, increment);
    }
}

