/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.compiler;

import com.zergatul.cheatutils.scripting.compiler.CompilerMethodVisitor;
import com.zergatul.cheatutils.scripting.compiler.LoopContextStack;
import com.zergatul.cheatutils.scripting.compiler.VariableContextStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.Label;

public class BufferVisitor
extends CompilerMethodVisitor {
    private final VariableContextStack contexts;
    private final List<Consumer<CompilerMethodVisitor>> list = new ArrayList<Consumer<CompilerMethodVisitor>>();

    public BufferVisitor(VariableContextStack contexts) {
        this.contexts = contexts;
    }

    @Override
    public VariableContextStack getContextStack() {
        return this.contexts;
    }

    @Override
    public LoopContextStack getLoops() {
        return null;
    }

    public void releaseBuffer(CompilerMethodVisitor visitor) {
        this.list.forEach(c -> c.accept(visitor));
        this.list.clear();
    }

    @Override
    public void visitInsn(int opcode) {
        this.list.add(v -> v.visitInsn(opcode));
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.list.add(v -> v.visitIntInsn(opcode, operand));
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.list.add(v -> v.visitFieldInsn(opcode, owner, name, descriptor));
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.list.add(v -> v.visitJumpInsn(opcode, label));
    }

    @Override
    public void visitLabel(Label label) {
        this.list.add(v -> v.visitLabel(label));
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.list.add(v -> v.visitLdcInsn(value));
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.list.add(v -> v.visitMethodInsn(opcode, owner, name, descriptor, isInterface));
    }

    @Override
    public void visitTypeInsn(int opcode, String descriptor) {
        this.list.add(v -> v.visitTypeInsn(opcode, descriptor));
    }

    @Override
    public void visitVarInsn(int opcode, int index) {
        this.list.add(v -> v.visitVarInsn(opcode, index));
    }

    @Override
    public void visitIincInsn(int varIndex, int increment) {
        this.list.add(v -> v.visitIincInsn(varIndex, increment));
    }
}

