/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.controllers.TeleportHackController;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import com.zergatul.cheatutils.utils.MathUtils;

public class TeleportApi {
    @ApiVisibility(value={ApiType.ACTION})
    public boolean toCrosshair(double distance, int repeats) {
        distance = MathUtils.clamp(distance, 1.0, 1000.0);
        repeats = MathUtils.clamp(repeats, 0, 100);
        return TeleportHackController.instance.teleportToCrosshair(distance, repeats);
    }

    @ApiVisibility(value={ApiType.ACTION})
    public boolean vertical(double distance, int repeats) {
        distance = MathUtils.absClamp(distance, 1.0, 1000.0);
        repeats = MathUtils.clamp(repeats, 0, 100);
        return TeleportHackController.instance.verticalTeleport(distance, repeats);
    }

    @ApiVisibility(value={ApiType.ACTION})
    public boolean vertical(double fromDistance, double toDistance, boolean findSurface, int repeats) {
        fromDistance = MathUtils.absClamp(fromDistance, -1000.0, 1000.0);
        toDistance = MathUtils.absClamp(toDistance, -1000.0, 1000.0);
        repeats = MathUtils.clamp(repeats, 0, 100);
        return TeleportHackController.instance.verticalTeleport(fromDistance, toDistance, findSurface, repeats);
    }
}

