/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.MovementHackConfig;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import java.util.Locale;

public class MovementApi {
    public boolean isSpeedMultiplierEnabled() {
        MovementHackConfig config = this.getConfig();
        return config.scaleInputVector;
    }

    public String getSpeedMultiplierFactor() {
        MovementHackConfig config = this.getConfig();
        return String.format(Locale.ROOT, "%.3f", config.inputVectorFactor);
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggleSpeedMultiplier() {
        MovementHackConfig config = this.getConfig();
        config.scaleInputVector = !config.scaleInputVector;
        ConfigStore.instance.requestWrite();
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void setSpeedMultiplierFactor(double value) {
        MovementHackConfig config = this.getConfig();
        config.inputVectorFactor = value;
        config.validate();
        ConfigStore.instance.requestWrite();
    }

    public boolean isOverrideJumpHeightEnabled() {
        MovementHackConfig config = this.getConfig();
        return config.scaleJumpHeight;
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggleOverrideJumpHeight() {
        MovementHackConfig config = this.getConfig();
        config.scaleJumpHeight = !config.scaleJumpHeight;
        ConfigStore.instance.requestWrite();
    }

    public String getJumpFactor() {
        MovementHackConfig config = this.getConfig();
        return String.format(Locale.ROOT, "%.3f", config.jumpHeightFactor);
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void setJumpFactor(double value) {
        MovementHackConfig config = this.getConfig();
        config.jumpHeightFactor = value;
        config.validate();
        ConfigStore.instance.requestWrite();
    }

    private MovementHackConfig getConfig() {
        return ConfigStore.instance.getConfig().movementHackConfig;
    }
}

