/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ModuleConfig;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;

public abstract class ModuleApi<T extends ModuleConfig> {
    public boolean isEnabled() {
        return ((ModuleConfig)this.getConfig()).enabled;
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void enable() {
        T config = this.getConfig();
        if (!((ModuleConfig)config).enabled) {
            ((ModuleConfig)config).enabled = true;
            this.onEnableChanged();
            ConfigStore.instance.requestWrite();
        }
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void disable() {
        T config = this.getConfig();
        if (((ModuleConfig)config).enabled) {
            ((ModuleConfig)config).enabled = false;
            this.onEnableChanged();
            ConfigStore.instance.requestWrite();
        }
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void setEnabled(boolean value) {
        T config = this.getConfig();
        if (((ModuleConfig)config).enabled != value) {
            ((ModuleConfig)config).enabled = value;
            this.onEnableChanged();
            ConfigStore.instance.requestWrite();
        }
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggle() {
        T config = this.getConfig();
        ((ModuleConfig)config).enabled = !((ModuleConfig)config).enabled;
        this.onEnableChanged();
        ConfigStore.instance.requestWrite();
    }

    protected void onEnableChanged() {
    }

    protected abstract T getConfig();
}

