/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.controllers.SpeedCounterController;
import com.zergatul.cheatutils.modules.scripting.StatusOverlay;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import com.zergatul.cheatutils.scripting.api.HelpText;
import com.zergatul.cheatutils.utils.ColorUtils;
import java.util.Comparator;
import java.util.Locale;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class MainApi {
    private final Minecraft mc = Minecraft.m_91087_();

    public boolean isEspEnabled() {
        return ConfigStore.instance.getConfig().esp;
    }

    public void toggleEsp() {
        ConfigStore.instance.getConfig().esp = !ConfigStore.instance.getConfig().esp;
        ConfigStore.instance.requestWrite();
    }

    @ApiVisibility(value={ApiType.ACTION})
    public void chat(String text) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.f_108617_.m_246175_(text);
        }
    }

    @HelpText(value="for server commands, like /home")
    @ApiVisibility(value={ApiType.ACTION})
    public void command(String text) {
        LocalPlayer player;
        if (text != null && text.startsWith("/") && (player = Minecraft.m_91087_().f_91074_) != null) {
            player.f_108617_.m_246623_(text.substring(1));
        }
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void systemMessage(String text) {
        this.showMessage(this.constructMessage(text), false);
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void overlayMessage(String text) {
        this.showMessage(this.constructMessage(text), true);
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void systemMessage(String color, String text) {
        this.showMessage(this.constructMessage(color, text), false);
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void overlayMessage(String color, String text) {
        this.showMessage(this.constructMessage(color, text), true);
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void systemMessage(String color1, String text1, String color2, String text2) {
        this.showMessage(this.constructMessage(color1, text1, color2, text2), false);
    }

    @ApiVisibility(value={ApiType.ACTION, ApiType.LOGGING})
    public void overlayMessage(String color1, String text1, String color2, String text2) {
        this.showMessage(this.constructMessage(color1, text1, color2, text2), true);
    }

    @ApiVisibility(value={ApiType.ACTION})
    public void openClosestChestBoat() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            Stream<ChestBoat> boats = StreamSupport.stream(mc.f_91073_.m_104735_().spliterator(), false).filter(e -> e instanceof ChestBoat).map(e -> (ChestBoat)e);
            double minDistance = Double.MAX_VALUE;
            ChestBoat target = null;
            for (ChestBoat boat : boats.toList()) {
                double d2 = mc.f_91074_.m_20280_((Entity)boat);
                if (!(d2 < minDistance)) continue;
                minDistance = d2;
                target = boat;
            }
            if (target == null) {
                return;
            }
            boolean oldShiftKeyDown = mc.f_91074_.f_108618_.f_108573_;
            mc.f_91074_.f_108618_.f_108573_ = true;
            mc.f_91072_.m_105230_((Player)mc.f_91074_, (Entity)target, new EntityHitResult((Entity)target), InteractionHand.MAIN_HAND);
            mc.f_91072_.m_105226_((Player)mc.f_91074_, (Entity)target, InteractionHand.MAIN_HAND);
            mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            mc.f_91074_.f_108618_.f_108573_ = oldShiftKeyDown;
        }
    }

    @ApiVisibility(value={ApiType.ACTION})
    public void openTradingWithClosestVillager() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && mc.f_91074_ != null) {
            Villager villager = StreamSupport.stream(mc.f_91073_.m_104735_().spliterator(), false).filter(e -> Villager.class.isInstance(e)).map(e -> (Villager)e).min(Comparator.comparingDouble(v -> mc.f_91074_.m_20280_((Entity)v))).orElse(null);
            if (villager == null) {
                return;
            }
            this.interactWithEntity(mc, (Entity)villager);
        }
    }

    @ApiVisibility(value={ApiType.OVERLAY})
    public void addText(String text) {
        this.addText("#FFFFFF", text);
    }

    @ApiVisibility(value={ApiType.OVERLAY})
    public void addText(String color, String text) {
        Integer colorInt = ColorUtils.parseColor(color);
        MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text));
        if (colorInt != null) {
            component = component.m_130948_(Style.f_131099_.m_178520_(colorInt.intValue()));
        }
        StatusOverlay.instance.addText(component);
    }

    @ApiVisibility(value={ApiType.OVERLAY})
    public void addText(String color1, String text1, String color2, String text2) {
        Integer color1Int = ColorUtils.parseColor(color1);
        Integer color2Int = ColorUtils.parseColor(color2);
        MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text1));
        if (color1Int != null) {
            component1 = component1.m_130948_(Style.f_131099_.m_178520_(color1Int.intValue()));
        }
        MutableComponent component2 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text2));
        if (color2Int != null) {
            component2 = component2.m_130948_(Style.f_131099_.m_178520_(color2Int.intValue()));
        }
        StatusOverlay.instance.addText(component1.m_130946_(" ").m_7220_((Component)component2));
    }

    @ApiVisibility(value={ApiType.OVERLAY})
    public void addTextAtPosition(int x, int y, String color, String text) {
        Integer colorInt = ColorUtils.parseColor(color);
        MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text));
        if (colorInt != null) {
            component = component.m_130948_(Style.f_131099_.m_178520_(colorInt.intValue()));
        }
        StatusOverlay.instance.addFreeText(x, y, component);
    }

    @ApiVisibility(value={ApiType.OVERLAY})
    public void addTextAtPosition(int x, int y, String color1, String text1, String color2, String text2) {
        Integer color1Int = ColorUtils.parseColor(color1);
        Integer color2Int = ColorUtils.parseColor(color2);
        MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text1));
        if (color1Int != null) {
            component1 = component1.m_130948_(Style.f_131099_.m_178520_(color1Int.intValue()));
        }
        MutableComponent component2 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text2));
        if (color2Int != null) {
            component2 = component2.m_130948_(Style.f_131099_.m_178520_(color2Int.intValue()));
        }
        StatusOverlay.instance.addFreeText(x, y, component1.m_130946_(" ").m_7220_((Component)component2));
    }

    public String getCoordinates() {
        return String.format(Locale.ROOT, "%.3f / %.5f / %.3f", this.mc.m_91288_().m_20185_(), this.mc.m_91288_().m_20186_(), this.mc.m_91288_().m_20189_());
    }

    @HelpText(value="If you are in the Overworld, returns calculated coordinates in the Nether")
    public String getCalcNetherCoordinates() {
        if (this.mc.f_91073_ == null || this.mc.f_91073_.m_46472_() == Level.f_46429_) {
            return "";
        }
        return String.format(Locale.ROOT, "%.3f / %.5f / %.3f", this.mc.m_91288_().m_20185_() / 8.0, this.mc.m_91288_().m_20186_(), this.mc.m_91288_().m_20189_() / 8.0);
    }

    @HelpText(value="If you are in the Nether, returns calculated coordinates in the Overworld")
    public String getCalcOverworldCoordinates() {
        if (this.mc.f_91073_ == null || this.mc.f_91073_.m_46472_() == Level.f_46428_) {
            return "";
        }
        return String.format(Locale.ROOT, "%.3f / %.5f / %.3f", this.mc.m_91288_().m_20185_() * 8.0, this.mc.m_91288_().m_20186_(), this.mc.m_91288_().m_20189_() * 8.0);
    }

    public boolean isDebugScreenEnabled() {
        return this.mc.f_91066_.f_92063_;
    }

    @HelpText(value="Allowed values: \"left\", \"center\", \"right\".")
    @ApiVisibility(value={ApiType.OVERLAY})
    public void setOverlayHorizontalPosition(String position) {
        if (position != null) {
            position = position.toLowerCase(Locale.ROOT);
        }
        switch (position) {
            case "left": {
                StatusOverlay.instance.setHorizontalAlign(StatusOverlay.HorizontalAlign.LEFT);
                break;
            }
            case "center": {
                StatusOverlay.instance.setHorizontalAlign(StatusOverlay.HorizontalAlign.CENTER);
                break;
            }
            default: {
                StatusOverlay.instance.setHorizontalAlign(StatusOverlay.HorizontalAlign.RIGHT);
            }
        }
    }

    @HelpText(value="Allowed values: \"top\", \"middle\", \"bottom\".")
    @ApiVisibility(value={ApiType.OVERLAY})
    public void setOverlayVerticalPosition(String position) {
        if (position != null) {
            position = position.toLowerCase(Locale.ROOT);
        }
        switch (position) {
            case "top": {
                StatusOverlay.instance.setVerticalAlign(StatusOverlay.VerticalAlign.TOP);
                break;
            }
            case "middle": {
                StatusOverlay.instance.setVerticalAlign(StatusOverlay.VerticalAlign.MIDDLE);
                break;
            }
            default: {
                StatusOverlay.instance.setVerticalAlign(StatusOverlay.VerticalAlign.BOTTOM);
            }
        }
    }

    public String getTargetBlockCoordinates() {
        if (this.mc.f_91073_ == null) {
            return "";
        }
        Entity entity = this.mc.m_91288_();
        if (entity == null) {
            return "";
        }
        HitResult result = entity.m_19907_(20.0, 0.0f, false);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)result).m_82425_();
            return blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_();
        }
        return "";
    }

    public String getTargetBlockName() {
        if (this.mc.f_91073_ == null) {
            return "";
        }
        Entity entity = this.mc.m_91288_();
        if (entity == null) {
            return "";
        }
        HitResult result = entity.m_19907_(20.0, 0.0f, false);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)result).m_82425_();
            BlockState blockState = this.mc.f_91073_.m_8055_(blockPos);
            return Registries.BLOCKS.getKey(blockState.m_60734_()).toString();
        }
        return "";
    }

    public String getBlockCoordinates() {
        BlockPos blockPos = this.mc.m_91288_().m_20183_();
        return String.format(Locale.ROOT, "%d %d %d [%d %d]", blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), blockPos.m_123341_() & 0xF, blockPos.m_123343_() & 0xF);
    }

    public String getChunkCoordinates() {
        BlockPos blockPos = this.mc.m_91288_().m_20183_();
        ChunkPos chunkPos = new ChunkPos(blockPos);
        return String.format(Locale.ROOT, "%d %d", chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public String getDirection() {
        Direction direction = this.mc.m_91288_().m_6350_();
        return direction.m_122433_();
    }

    public String getBiome() {
        if (this.mc.f_91073_ == null || this.mc.m_91288_() == null) {
            return "";
        }
        BlockPos blockPos = this.mc.m_91288_().m_20183_();
        Holder holder = this.mc.f_91073_.m_204166_(blockPos);
        return (String)holder.m_203439_().map(id -> id.m_135782_().toString(), biome -> "[unregistered " + String.valueOf(biome) + "]");
    }

    @HelpText(value="Measured in 0.5 sec window.")
    public String getHorizontalSpeed() {
        return String.format(Locale.ROOT, "%.3f", SpeedCounterController.instance.getHorizontalSpeed());
    }

    @HelpText(value="Measured in 0.5 sec window.")
    public String getSpeed() {
        return String.format(Locale.ROOT, "%.3f", SpeedCounterController.instance.getSpeed());
    }

    private void interactWithEntity(Minecraft mc, Entity entity) {
        mc.f_91072_.m_105230_((Player)mc.f_91074_, entity, new EntityHitResult(entity), InteractionHand.MAIN_HAND);
        mc.f_91072_.m_105226_((Player)mc.f_91074_, entity, InteractionHand.MAIN_HAND);
        mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
    }

    private MutableComponent constructMessage(String text) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(text));
    }

    private MutableComponent constructMessage(String color, String text) {
        Integer colorInt = ColorUtils.parseColor(color);
        MutableComponent component = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text));
        if (colorInt != null) {
            component = component.m_130948_(Style.f_131099_.m_178520_(colorInt.intValue()));
        }
        return component;
    }

    private MutableComponent constructMessage(String color1, String text1, String color2, String text2) {
        Integer color1Int = ColorUtils.parseColor(color1);
        Integer color2Int = ColorUtils.parseColor(color2);
        MutableComponent component1 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text1));
        if (color1Int != null) {
            component1 = component1.m_130948_(Style.f_131099_.m_178520_(color1Int.intValue()));
        }
        MutableComponent component2 = MutableComponent.m_237204_((ComponentContents)new LiteralContents(text2));
        if (color2Int != null) {
            component2 = component2.m_130948_(Style.f_131099_.m_178520_(color2Int.intValue()));
        }
        return component1.m_130946_(" ").m_7220_((Component)component2);
    }

    private void showMessage(MutableComponent message, boolean overlay) {
        Minecraft.m_91087_().m_240442_().m_240494_((Component)message, overlay);
    }
}

