/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import com.zergatul.cheatutils.scripting.api.HelpText;
import com.zergatul.cheatutils.utils.InventorySlot;
import com.zergatul.cheatutils.utils.InventoryUtils;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryApi {
    private static final Minecraft mc = Minecraft.m_91087_();

    public String getHeadItemId() {
        return this.getItemIdBySlot(EquipmentSlot.HEAD);
    }

    public String getChestItemId() {
        return this.getItemIdBySlot(EquipmentSlot.CHEST);
    }

    public String getLegsItemId() {
        return this.getItemIdBySlot(EquipmentSlot.LEGS);
    }

    public String getFeetItemId() {
        return this.getItemIdBySlot(EquipmentSlot.FEET);
    }

    public String getMainHandItemId() {
        return this.getItemIdBySlot(EquipmentSlot.MAINHAND);
    }

    public String getOffHandItemId() {
        return this.getItemIdBySlot(EquipmentSlot.OFFHAND);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getHeadItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.HEAD);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getChestItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.CHEST);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getLegsItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.LEGS);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getFeetItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.FEET);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getMainHandItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.MAINHAND);
    }

    @HelpText(value="Returns value from (0..1]")
    public double getOffHandItemDurability() {
        return this.getItemDurabilityBySlot(EquipmentSlot.OFFHAND);
    }

    @ApiVisibility(value={ApiType.ACTION})
    public boolean equip(String itemId) {
        return this.equip(itemId, itemStack -> {
            EquipmentSlot slot = Mob.m_147233_((ItemStack)itemStack);
            return slot == EquipmentSlot.MAINHAND ? null : slot;
        });
    }

    @HelpText(value="Allows you to equip any item")
    @ApiVisibility(value={ApiType.ACTION})
    public boolean swapEquipHead(String itemId) {
        return this.equip(itemId, true, itemStack -> EquipmentSlot.HEAD);
    }

    @HelpText(value="Allows you to equip any item")
    @ApiVisibility(value={ApiType.ACTION})
    public boolean swapEquipChest(String itemId) {
        return this.equip(itemId, true, itemStack -> EquipmentSlot.CHEST);
    }

    @HelpText(value="Allows you to equip any item")
    @ApiVisibility(value={ApiType.ACTION})
    public boolean swapEquipLegs(String itemId) {
        return this.equip(itemId, true, itemStack -> EquipmentSlot.LEGS);
    }

    @HelpText(value="Allows you to equip any item")
    @ApiVisibility(value={ApiType.ACTION})
    public boolean swapEquipFeet(String itemId) {
        return this.equip(itemId, true, itemStack -> EquipmentSlot.FEET);
    }

    public int getCount(String itemId) {
        if (InventoryApi.mc.f_91074_ == null) {
            return 0;
        }
        Item item = Registries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            return -1;
        }
        Inventory inventory = InventoryApi.mc.f_91074_.m_150109_();
        int count = 0;
        int size = inventory.m_6643_();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (!itemStack.m_150930_(item)) continue;
            count += itemStack.m_41613_();
        }
        return count;
    }

    private String getItemIdBySlot(EquipmentSlot slot) {
        if (InventoryApi.mc.f_91074_ == null) {
            return "";
        }
        ItemStack itemStack = InventoryApi.mc.f_91074_.m_6844_(slot);
        if (itemStack.m_41619_()) {
            return "";
        }
        return Registries.ITEMS.getKey(itemStack.m_41720_()).toString();
    }

    private double getItemDurabilityBySlot(EquipmentSlot slot) {
        if (InventoryApi.mc.f_91074_ == null) {
            return 1.0;
        }
        ItemStack itemStack = InventoryApi.mc.f_91074_.m_6844_(slot);
        if (itemStack.m_41619_()) {
            return 1.0;
        }
        if (!itemStack.m_41768_()) {
            return 1.0;
        }
        if (itemStack.m_41776_() == 0) {
            return 1.0;
        }
        return 1.0 - 1.0 * (double)itemStack.m_41773_() / (double)itemStack.m_41776_();
    }

    private int find(String itemId) {
        int i;
        if (InventoryApi.mc.f_91074_ == null) {
            return -1;
        }
        Item item = Registries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            return -1;
        }
        Inventory inventory = InventoryApi.mc.f_91074_.m_150109_();
        for (i = 9; i < 36; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            return i;
        }
        for (i = 0; i < 9; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    private boolean equip(String itemId, Function<ItemStack, EquipmentSlot> getSlot) {
        return this.equip(itemId, false, getSlot);
    }

    private boolean equip(String itemId, boolean swap, Function<ItemStack, EquipmentSlot> getSlot) {
        int i;
        if (InventoryApi.mc.f_91074_ == null) {
            return false;
        }
        Item item = Registries.ITEMS.getValue(new ResourceLocation(itemId));
        if (item == null) {
            return false;
        }
        Inventory inventory = InventoryApi.mc.f_91074_.m_150109_();
        int index = -1;
        ItemStack itemStack = null;
        for (i = 9; i < 36; ++i) {
            if (!inventory.m_8020_(i).m_150930_(item)) continue;
            index = i;
            itemStack = inventory.m_8020_(i);
            break;
        }
        if (itemStack == null) {
            for (i = 0; i < 9; ++i) {
                if (!inventory.m_8020_(i).m_150930_(item)) continue;
                index = i;
                itemStack = inventory.m_8020_(i);
                break;
            }
        }
        if (itemStack == null) {
            return false;
        }
        EquipmentSlot slot = getSlot.apply(itemStack);
        if (slot == null) {
            return false;
        }
        if (swap) {
            InventoryUtils.swapItemStack(new InventorySlot(index), new InventorySlot(slot));
        } else {
            InventoryUtils.moveItemStack(new InventorySlot(index), new InventorySlot(slot));
        }
        return true;
    }
}

