/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.FreeCamConfig;
import com.zergatul.cheatutils.modules.esp.FreeCam;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class FreeCamApi {
    private final Minecraft mc = Minecraft.m_91087_();

    public boolean isEnabled() {
        return FreeCam.instance.isActive();
    }

    public String getCoordinates() {
        FreeCam fc = FreeCam.instance;
        if (fc.isActive()) {
            return String.format(Locale.ROOT, "%.3f / %.5f / %.3f", fc.getX(), fc.getY(), fc.getZ());
        }
        return "";
    }

    public String getTargetBlockCoordinates() {
        if (this.mc.f_91073_ == null || !FreeCam.instance.isActive()) {
            return "";
        }
        HitResult hitResult = FreeCam.instance.getHitResult();
        if (hitResult == null) {
            return "";
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)hitResult).m_82425_();
            return blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_();
        }
        return "";
    }

    public String getTargetBlockName() {
        if (this.mc.f_91073_ == null || !FreeCam.instance.isActive()) {
            return "";
        }
        HitResult hitResult = FreeCam.instance.getHitResult();
        if (hitResult == null) {
            return "";
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockPos = ((BlockHitResult)hitResult).m_82425_();
            BlockState blockState = this.mc.f_91073_.m_8055_(blockPos);
            return Registries.BLOCKS.getKey(blockState.m_60734_()).toString();
        }
        return "";
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggle() {
        FreeCam.instance.toggle();
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggleRenderHands() {
        FreeCamConfig config = this.getConfig();
        config.renderHands = !config.renderHands;
        ConfigStore.instance.requestWrite();
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void setRenderHands(boolean value) {
        FreeCamConfig config = this.getConfig();
        config.renderHands = value;
        ConfigStore.instance.requestWrite();
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void startPath() {
        FreeCam.instance.startPath();
    }

    private FreeCamConfig getConfig() {
        return ConfigStore.instance.getConfig().freeCamConfig;
    }
}

