/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.collections.ImmutableList;
import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.EntityTracerConfig;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import com.zergatul.cheatutils.utils.EntityUtils;
import com.zergatul.cheatutils.wrappers.ClassRemapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntitiesApi {
    public boolean isEnabled(String className) {
        EntityTracerConfig config = this.getConfig(className);
        if (config == null) {
            return false;
        }
        return config.enabled;
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggle(String className) {
        EntityTracerConfig config = this.getConfig(className);
        if (config == null) {
            return;
        }
        config.enabled = !config.enabled;
        ConfigStore.instance.requestWrite();
    }

    public int getCount(String className) {
        EntityUtils.EntityInfo info = EntityUtils.getEntityClass(ClassRemapper.toObf(className));
        if (info == null) {
            return Integer.MIN_VALUE;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return 0;
        }
        int count = 0;
        for (Entity entity : level.m_104735_()) {
            if (!info.clazz.isAssignableFrom(entity.getClass())) continue;
            ++count;
        }
        return count;
    }

    public int getCountById(String id) {
        ResourceLocation location = new ResourceLocation(id);
        EntityType<?> type = Registries.ENTITY_TYPES.getValue(location);
        if (type == null) {
            return Integer.MIN_VALUE;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return 0;
        }
        int count = 0;
        for (Entity entity : level.m_104735_()) {
            if (entity.m_6095_() != type) continue;
            ++count;
        }
        return count;
    }

    private EntityTracerConfig getConfig(String className) {
        ImmutableList<EntityTracerConfig> list = ConfigStore.instance.getConfig().entities.configs;
        return list.stream().filter(c -> c.clazz.getName().equals(ClassRemapper.toObf(className))).findFirst().orElse(null);
    }
}

