/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.scripting.api.HelpText;
import com.zergatul.cheatutils.utils.ColorUtils;
import com.zergatul.cheatutils.utils.MathUtils;
import java.awt.Color;

public class ColorApi {
    public String toHex(int red, int green, int blue) {
        red = MathUtils.clamp(red, 0, 255);
        green = MathUtils.clamp(green, 0, 255);
        blue = MathUtils.clamp(blue, 0, 255);
        return String.format("#%02X%02X%02X", red, green, blue);
    }

    @HelpText(value="value should be [0..1]")
    public String gradient(String color1, String color2, double value) {
        value = MathUtils.clamp(value, 0.0, 1.0);
        Color c1 = ColorUtils.parseColor2(color1);
        Color c2 = ColorUtils.parseColor2(color2);
        if (c1 == null || c2 == null) {
            return "";
        }
        return this.toHex((int)Math.round((double)c1.getRed() + (double)(c2.getRed() - c1.getRed()) * value), (int)Math.round((double)c1.getGreen() + (double)(c2.getGreen() - c1.getGreen()) * value), (int)Math.round((double)c1.getBlue() + (double)(c2.getBlue() - c1.getBlue()) * value));
    }
}

