/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.scripting.api.modules;

import com.zergatul.cheatutils.common.Registries;
import com.zergatul.cheatutils.configs.BlockTracerConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.scripting.api.ApiType;
import com.zergatul.cheatutils.scripting.api.ApiVisibility;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class BlocksApi {
    public boolean isEnabled(String blockId) {
        BlockTracerConfig config = this.getConfig(blockId);
        if (config == null) {
            return false;
        }
        return config.enabled;
    }

    @ApiVisibility(value={ApiType.UPDATE})
    public void toggle(String blockId) {
        BlockTracerConfig config = this.getConfig(blockId);
        if (config == null) {
            return;
        }
        config.enabled = !config.enabled;
        ConfigStore.instance.requestWrite();
    }

    private BlockTracerConfig getConfig(String blockId) {
        ResourceLocation location = new ResourceLocation(blockId);
        Block block = Registries.BLOCKS.getValue(location);
        if (block == null) {
            return null;
        }
        return ConfigStore.instance.getConfig().blocks.configs.stream().filter(c -> c.block == block).findFirst().orElse(null);
    }
}

