/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.schematics;

import com.zergatul.cheatutils.schematics.AlphaMapping;
import com.zergatul.cheatutils.schematics.InvalidFormatException;
import com.zergatul.cheatutils.schematics.MissingPaletteEntryException;
import com.zergatul.cheatutils.schematics.SchemaFileEditable;
import com.zergatul.cheatutils.utils.NbtUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SchematicFile
implements SchemaFileEditable {
    private static final String WIDTH_TAG = "Width";
    private static final String HEIGHT_TAG = "Height";
    private static final String LENGTH_TAG = "Length";
    private static final String BLOCKS_TAG = "Blocks";
    private static final String DATA_TAG = "Data";
    private final CompoundTag compound;
    private final int width;
    private final int height;
    private final int length;
    private final byte[] blocks;
    private final byte[] data;
    private final int[] summary;
    private final BlockState[] palette;
    private final Map<BlockState, Integer> reversePalette;

    public SchematicFile(byte[] data) throws IOException, InvalidFormatException {
        this(NbtIo.m_128939_((InputStream)new ByteArrayInputStream(data)));
    }

    public SchematicFile(int width, int height, int length) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blocks = new byte[width * height * length];
        this.data = new byte[width * height * length];
        this.summary = new int[256];
        this.palette = new BlockState[256];
        this.palette[0] = Blocks.f_50016_.m_49966_();
        this.reversePalette = this.CreateReversePalette();
        this.summary[0] = this.blocks.length;
        this.compound = new CompoundTag();
        this.compound.m_128376_(WIDTH_TAG, (short)width);
        this.compound.m_128376_(HEIGHT_TAG, (short)height);
        this.compound.m_128376_(LENGTH_TAG, (short)length);
        this.compound.m_128382_(DATA_TAG, new byte[0]);
    }

    private SchematicFile(CompoundTag compound) throws InvalidFormatException {
        this.ValidateRequiredTags(compound);
        this.compound = compound;
        this.width = compound.m_128448_(WIDTH_TAG);
        this.height = compound.m_128448_(HEIGHT_TAG);
        this.length = compound.m_128448_(LENGTH_TAG);
        this.blocks = compound.m_128463_(BLOCKS_TAG);
        this.data = compound.m_128463_(DATA_TAG);
        this.ValidateSize();
        this.summary = this.CreateSummary();
        this.palette = this.CreatePalette();
        this.reversePalette = this.CreateReversePalette();
    }

    private void ValidateRequiredTags(CompoundTag compound) throws InvalidFormatException {
        if (!NbtUtils.hasShort(compound, WIDTH_TAG)) {
            throw new InvalidFormatException("Invalid NBT structure. [Width] ShortTag is required.");
        }
        if (!NbtUtils.hasShort(compound, HEIGHT_TAG)) {
            throw new InvalidFormatException("Invalid NBT structure. [Height] ShortTag is required.");
        }
        if (!NbtUtils.hasShort(compound, LENGTH_TAG)) {
            throw new InvalidFormatException("Invalid NBT structure. [Length] ShortTag is required.");
        }
        if (!NbtUtils.hasBytes(compound, BLOCKS_TAG)) {
            throw new InvalidFormatException("Invalid NBT structure. [Blocks] ByteArrayTag is required.");
        }
    }

    private void ValidateSize() throws InvalidFormatException {
        int size = this.width * this.height * this.length;
        if (this.blocks.length != size) {
            throw new InvalidFormatException(String.format("[Blocks] ByteArrayTag length is %s, but it should be %s.", this.blocks.length, size));
        }
    }

    private int[] CreateSummary() {
        int[] summary = new int[65536];
        int size = this.width * this.height * this.length;
        for (int i = 0; i < size; ++i) {
            int n = Byte.toUnsignedInt(this.blocks[i]) << 8 | this.getData(i);
            summary[n] = summary[n] + 1;
        }
        return summary;
    }

    private BlockState[] CreatePalette() throws InvalidFormatException {
        if (NbtUtils.hasCompound(this.compound, "SchematicaMapping")) {
            throw new InvalidFormatException("Not implemented");
        }
        if (NbtUtils.hasCompound(this.compound, "BlockIDs")) {
            throw new InvalidFormatException("Not implemented");
        }
        if (NbtUtils.hasString(this.compound, "Materials")) {
            String materials;
            switch (materials = this.compound.m_128461_("Materials")) {
                case "Alpha": {
                    return AlphaMapping.get();
                }
            }
            throw new InvalidFormatException(String.format("Materials type %s is not implemented.", materials));
        }
        return AlphaMapping.get();
    }

    private Map<BlockState, Integer> CreateReversePalette() {
        HashMap<BlockState, Integer> map = new HashMap<BlockState, Integer>();
        for (int i = 0; i < this.palette.length; ++i) {
            BlockState state = this.palette[i];
            if (state == null || map.containsKey(state)) continue;
            map.put(state, i);
        }
        return map;
    }

    private int getData(int index) {
        return index < this.data.length ? Byte.toUnsignedInt(this.data[index]) : 0;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        int index = (y * this.length + z) * this.width + x;
        return this.palette[Byte.toUnsignedInt(this.blocks[index]) << 8 | this.getData(index)];
    }

    @Override
    public int[] getSummary() {
        return this.summary;
    }

    @Override
    public BlockState[] getPalette() {
        return this.palette;
    }

    @Override
    public void write(OutputStream output) throws IOException {
        this.compound.m_128382_(BLOCKS_TAG, this.blocks);
        NbtIo.m_128947_((CompoundTag)this.compound, (OutputStream)output);
    }

    @Override
    public void setBlockState(int x, int y, int z, BlockState state) throws MissingPaletteEntryException {
        Integer value = this.reversePalette.get(state);
        if (value == null) {
            throw new MissingPaletteEntryException();
        }
        int index = (y * this.length + z) * this.width + x;
        this.blocks[index] = (byte)value.intValue();
    }

    @Override
    public void setPaletteEntry(int index, BlockState state) {
        this.palette[index] = state;
        this.reversePalette.put(state, index);
    }
}

