/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.schematics;

import com.zergatul.cheatutils.schematics.MissingPaletteEntryException;
import com.zergatul.cheatutils.schematics.SchemaFileEditable;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public interface SchemaFile {
    public int getWidth();

    public int getHeight();

    public int getLength();

    public BlockState getBlockState(int var1, int var2, int var3);

    public int[] getSummary();

    public BlockState[] getPalette();

    public void write(OutputStream var1) throws IOException;

    default public Vec3i getSize() {
        return new Vec3i(this.getWidth(), this.getHeight(), this.getLength());
    }

    default public void copyTo(SchemaFileEditable file, int destX, int destY, int destZ) throws MissingPaletteEntryException {
        int width = this.getWidth();
        int height = this.getHeight();
        int length = this.getLength();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    BlockState state = this.getBlockState(x, y, z);
                    file.setBlockState(destX + x, destY + y, destZ + z, state);
                }
            }
        }
    }
}

