/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.schematics;

import com.zergatul.cheatutils.schematics.BlockStateMapping;
import com.zergatul.cheatutils.schematics.InvalidFormatException;
import com.zergatul.cheatutils.schematics.SchemaFile;
import com.zergatul.cheatutils.utils.NbtUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LitematicFile
implements SchemaFile {
    private final CompoundTag compound;
    private final int version;
    private final int subVersion;
    private final int dataVersion;
    private final Region[] regions;

    public LitematicFile(byte[] data) throws IOException, InvalidFormatException {
        this(NbtIo.m_128939_((InputStream)new ByteArrayInputStream(data)));
    }

    private LitematicFile(CompoundTag compound) throws InvalidFormatException {
        this.ValidateRequiredTags(compound);
        this.compound = compound;
        this.version = compound.m_128451_("Version");
        this.subVersion = compound.m_128451_("SubVersion");
        this.dataVersion = compound.m_128451_("MinecraftDataVersion");
        CompoundTag regionCompounds = compound.m_128469_("Regions");
        this.regions = new Region[regionCompounds.m_128440_()];
        int index = 0;
        for (String key : regionCompounds.m_128431_()) {
            this.regions[index++] = new Region(key, regionCompounds.m_128469_(key));
        }
        if (this.regions.length == 0) {
            throw new InvalidFormatException("Zero regions.");
        }
        if (this.regions.length > 1) {
            throw new InvalidFormatException("More than 1 regions. Not supported.");
        }
    }

    private void ValidateRequiredTags(CompoundTag compound) throws InvalidFormatException {
        if (!NbtUtils.hasInt(compound, "Version")) {
            throw new InvalidFormatException("Invalid NBT structure. [Version] IntTag is required.");
        }
        if (!NbtUtils.hasInt(compound, "SubVersion")) {
            throw new InvalidFormatException("Invalid NBT structure. [SubVersion] IntTag is required.");
        }
        if (!NbtUtils.hasInt(compound, "MinecraftDataVersion")) {
            throw new InvalidFormatException("Invalid NBT structure. [MinecraftDataVersion] IntTag is required.");
        }
        if (!NbtUtils.hasCompound(compound, "Metadata")) {
            throw new InvalidFormatException("Invalid NBT structure. [Metadata] CompoundTag is required.");
        }
        if (!NbtUtils.hasCompound(compound, "Regions")) {
            throw new InvalidFormatException("Invalid NBT structure. [Regions] CompoundTag is required.");
        }
        CompoundTag regions = compound.m_128469_("Regions");
        for (String key : regions.m_128431_()) {
            this.ValidateRegion(regions.m_128469_(key), String.format("Invalid NBT structure in %s region", key));
        }
    }

    private void ValidateRegion(CompoundTag compound, String errorPrefix) throws InvalidFormatException {
        if (!NbtUtils.hasLongs(compound, "BlockStates")) {
            throw new InvalidFormatException(String.format("%s. [BlockStates] LongArrayTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasCompound(compound, "Position")) {
            throw new InvalidFormatException(String.format("%s. [Position] CompoundTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasList(compound, "BlockStatePalette")) {
            throw new InvalidFormatException(String.format("%s. [BlockStatePalette] ListTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasCompound(compound, "Size")) {
            throw new InvalidFormatException(String.format("%s. [Size] CompoundTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasList(compound, "TileEntities")) {
            throw new InvalidFormatException(String.format("%s. [TileEntities] ListTag is required.", errorPrefix));
        }
        this.ValidateVector(compound.m_128469_("Position"), errorPrefix + ", [Position] tag");
        this.ValidateVector(compound.m_128469_("Size"), errorPrefix + ", [Size] tag");
    }

    private void ValidateVector(CompoundTag compound, String errorPrefix) throws InvalidFormatException {
        if (!NbtUtils.hasInt(compound, "x")) {
            throw new InvalidFormatException(String.format("%s. [x] IntTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasInt(compound, "y")) {
            throw new InvalidFormatException(String.format("%s. [x] IntTag is required.", errorPrefix));
        }
        if (!NbtUtils.hasInt(compound, "z")) {
            throw new InvalidFormatException(String.format("%s. [x] IntTag is required.", errorPrefix));
        }
    }

    @Override
    public int getWidth() {
        return this.regions[0].width;
    }

    @Override
    public int getHeight() {
        return this.regions[0].height;
    }

    @Override
    public int getLength() {
        return this.regions[0].length;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        return this.regions[0].getBlockState(x, y, z);
    }

    @Override
    public int[] getSummary() {
        return this.regions[0].getSummary();
    }

    @Override
    public BlockState[] getPalette() {
        return this.regions[0].palette;
    }

    @Override
    public void write(OutputStream output) {
    }

    private static class Region {
        public final String name;
        private final int width;
        private final int height;
        private final int length;
        private final BlockState[] palette;
        private final long[] blocks;
        private final int bitSize;
        private final long bitMask;
        private final int[] summary;

        public Region(String name, CompoundTag compound) throws InvalidFormatException {
            this.name = name;
            CompoundTag sizeTag = compound.m_128469_("Size");
            this.width = sizeTag.m_128451_("x");
            this.height = sizeTag.m_128451_("y");
            this.length = sizeTag.m_128451_("z");
            this.palette = this.ParsePalette((ListTag)compound.m_128423_("BlockStatePalette"));
            this.blocks = compound.m_128467_("BlockStates");
            this.bitSize = 32 - Integer.numberOfLeadingZeros(this.palette.length);
            this.bitMask = (1L << this.bitSize) - 1L;
            this.summary = this.CreateSummary();
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getLength() {
            return this.length;
        }

        public BlockState getBlockState(int x, int y, int z) {
            return this.palette[this.getPaletteIndex(x, y, z)];
        }

        public int[] getSummary() {
            return this.summary;
        }

        private BlockState[] ParsePalette(ListTag list) throws InvalidFormatException {
            BlockState[] palette = new BlockState[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag item = (CompoundTag)list.get(i);
                String blockId = item.m_128461_("Name");
                CompoundTag propertiesTag = item.m_128469_("Properties");
                BlockStateMapping mapping = null;
                block1: for (BlockStateMapping m : BlockStateMapping.get()) {
                    if (!m.blockId.equals(blockId) || propertiesTag.m_128440_() != m.tags.size()) continue;
                    for (String key : propertiesTag.m_128431_()) {
                        Tag valueTag = propertiesTag.m_128423_(key);
                        if (!(valueTag instanceof StringTag)) {
                            throw new InvalidFormatException("Not implemented.");
                        }
                        StringTag stringTag = (StringTag)valueTag;
                        String value = stringTag.m_7916_();
                        Property property = m.tags.keySet().stream().filter(p -> p.m_61708_().equals(key)).findFirst().orElse(null);
                        if (property != null && value.equals(((Comparable)m.tags.get((Object)property)).toString())) continue;
                        continue block1;
                    }
                    mapping = m;
                    break;
                }
                if (mapping == null) {
                    throw new InvalidFormatException("Cannot read BlockState.");
                }
                palette[i] = mapping.state;
            }
            return palette;
        }

        private int[] CreateSummary() {
            int[] summary = new int[this.palette.length];
            int size = this.width * this.height * this.length;
            for (int i = 0; i < size; ++i) {
                int n = this.getPaletteIndex(i);
                summary[n] = summary[n] + 1;
            }
            return summary;
        }

        private int getPaletteIndex(int x, int y, int z) {
            return this.getPaletteIndex(((long)y * (long)this.length + (long)z) * (long)this.width + (long)x);
        }

        private int getPaletteIndex(long index) {
            long startOffset = index * (long)this.bitSize;
            int startArrIndex = (int)(startOffset >> 6);
            int endArrIndex = (int)((index + 1L) * (long)this.bitSize - 1L >> 6);
            int startBitOffset = (int)(startOffset & 0x3FL);
            if (startArrIndex == endArrIndex) {
                return (int)(this.blocks[startArrIndex] >>> startBitOffset & this.bitMask);
            }
            int endOffset = 64 - startBitOffset;
            return (int)((this.blocks[startArrIndex] >>> startBitOffset | this.blocks[endArrIndex] << endOffset) & this.bitMask);
        }
    }
}

