/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.zergatul.cheatutils.common.events.RenderWorldLastEvent;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class LineRenderer {
    protected BufferBuilder buffer;
    protected Vec3 view;
    protected Matrix4f modelViewMatrix;
    protected Matrix3f normalMatrix;
    protected Matrix4f projectionMatrix;
    protected boolean depthTest;

    public void begin(RenderWorldLastEvent event, boolean depthTest) {
        this.begin(event.getCamera().m_90583_(), event.getMatrixStack().m_85850_(), event.getProjectionMatrix(), depthTest);
    }

    public void begin(Vec3 view, PoseStack.Pose pose, Matrix4f projectionMatrix, boolean depthTest) {
        if (this.buffer != null) {
            throw new IllegalStateException("Rendered is already active");
        }
        this.view = view;
        this.normalMatrix = pose.m_252943_();
        this.modelViewMatrix = pose.m_252922_();
        this.projectionMatrix = projectionMatrix;
        this.depthTest = depthTest;
        this.buffer = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void line(double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        this.line(x1, y1, z1, r, g, b, a, x2, y2, z2, r, g, b, a);
    }

    public void cuboid(double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        this.line(x1, y1, z1, x1, y1, z2, r, g, b, a);
        this.line(x1, y1, z2, x2, y1, z2, r, g, b, a);
        this.line(x2, y1, z2, x2, y1, z1, r, g, b, a);
        this.line(x2, y1, z1, x1, y1, z1, r, g, b, a);
        this.line(x1, y2, z1, x1, y2, z2, r, g, b, a);
        this.line(x1, y2, z2, x2, y2, z2, r, g, b, a);
        this.line(x2, y2, z2, x2, y2, z1, r, g, b, a);
        this.line(x2, y2, z1, x1, y2, z1, r, g, b, a);
        this.line(x1, y1, z1, x1, y2, z1, r, g, b, a);
        this.line(x1, y1, z2, x1, y2, z2, r, g, b, a);
        this.line(x2, y1, z2, x2, y2, z2, r, g, b, a);
        this.line(x2, y1, z1, x2, y2, z1, r, g, b, a);
    }

    public abstract void line(double var1, double var3, double var5, float var7, float var8, float var9, float var10, double var11, double var13, double var15, float var17, float var18, float var19, float var20);

    public void end() {
        this.view = null;
        this.normalMatrix = null;
        this.modelViewMatrix = null;
        this.projectionMatrix = null;
        this.buffer = null;
    }
}

