/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.visuals;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.GetFieldOfViewEvent;
import com.zergatul.cheatutils.modules.Module;

public class Zoom
implements Module {
    public static final Zoom instance = new Zoom();
    private State state;
    private long begin;
    private long end;
    private double finalFov;
    private double fovFactor;

    private Zoom() {
        Events.GetFieldOfView.add(this::onGetFov);
        this.state = State.NONE;
    }

    public boolean isActive() {
        return this.state != State.NONE;
    }

    public void startZooming(double fov, double seconds) {
        switch (this.state) {
            case NONE: {
                this.state = State.ZOOM_IN;
                this.begin = System.nanoTime();
                this.end = this.begin + (long)(seconds * 1.0E9);
                this.finalFov = fov;
                break;
            }
            case ZOOM_STATIC: {
                if (this.finalFov == fov) break;
                this.finalFov = fov;
                break;
            }
            case ZOOM_OUT: {
                this.state = State.ZOOM_IN;
                long duration = this.end - this.begin;
                long now = System.nanoTime();
                long elapsed = now - this.begin;
                this.end = now + elapsed;
                this.begin = this.end - duration;
                this.finalFov = fov;
            }
        }
    }

    public void stopZooming() {
        switch (this.state) {
            case ZOOM_IN: {
                this.state = State.ZOOM_OUT;
                long duration = this.end - this.begin;
                long now = System.nanoTime();
                long elapsed = now - this.begin;
                this.end = now + elapsed;
                this.begin = this.end - duration;
                break;
            }
            case ZOOM_STATIC: {
                this.state = State.ZOOM_OUT;
                long duration = this.end - this.begin;
                this.begin = System.nanoTime();
                this.end = this.begin + duration;
            }
        }
    }

    public double getFovFactor() {
        return this.fovFactor;
    }

    private void onGetFov(GetFieldOfViewEvent event) {
        long now = System.nanoTime();
        double originalFov = event.get();
        switch (this.state) {
            case ZOOM_IN: {
                if (now >= this.end) {
                    this.state = State.ZOOM_STATIC;
                    this.onGetFov(event);
                    return;
                }
                double fraction = 1.0 * (double)(now - this.begin) / (double)(this.end - this.begin);
                double transform = this.linear(fraction);
                event.set(originalFov + transform * (this.finalFov - originalFov));
                break;
            }
            case ZOOM_STATIC: {
                event.set(this.finalFov);
                break;
            }
            case ZOOM_OUT: {
                if (now >= this.end) {
                    this.state = State.NONE;
                    return;
                }
                double fraction = 1.0 * (double)(this.end - now) / (double)(this.end - this.begin);
                double transform = this.linear(fraction);
                event.set(originalFov + transform * (this.finalFov - originalFov));
            }
        }
        this.fovFactor = event.get() / originalFov;
    }

    private double linear(double value) {
        return value;
    }

    private static enum State {
        NONE,
        ZOOM_IN,
        ZOOM_STATIC,
        ZOOM_OUT;

    }
}

