/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.visuals;

import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.GatherTooltipComponentsEvent;
import com.zergatul.cheatutils.configs.AdvancedTooltipsConfig;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.modules.Module;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AdvancedTooltips
implements Module {
    public static final AdvancedTooltips instance = new AdvancedTooltips();

    private AdvancedTooltips() {
        Events.GatherTooltipComponents.add(this::onGatherTooltipComponents);
    }

    private void onGatherTooltipComponents(GatherTooltipComponentsEvent event) {
        AdvancedTooltipsConfig config = ConfigStore.instance.getConfig().advancedTooltipsConfig;
        this.handleBeeContainer(config, event);
        this.handleRepairCost(config, event);
    }

    private void handleBeeContainer(AdvancedTooltipsConfig config, GatherTooltipComponentsEvent event) {
        ItemStack itemStack;
        Item item;
        if (config.beeContainer && ((item = (itemStack = event.itemStack()).m_41720_()) == Items.f_42785_ || item == Items.f_42786_)) {
            CompoundTag blockStateTag;
            CompoundTag blockEntityTag;
            int beesCount = 0;
            String honeyLevel = "";
            CompoundTag root = itemStack.m_41783_();
            if (root == null) {
                return;
            }
            if (root.m_128441_("BlockEntityTag") && (blockEntityTag = root.m_128469_("BlockEntityTag")).m_128441_("Bees")) {
                ListTag bees = (ListTag)blockEntityTag.m_128423_("Bees");
                beesCount = bees.size();
            }
            if (root.m_128441_("BlockStateTag") && (blockStateTag = root.m_128469_("BlockStateTag")).m_128441_("honey_level")) {
                honeyLevel = blockStateTag.m_128461_("honey_level");
            }
            event.list().add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Bees count: " + beesCount)).m_130940_(ChatFormatting.GRAY));
            event.list().add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Honey level: " + honeyLevel)).m_130940_(ChatFormatting.GRAY));
        }
    }

    private void handleRepairCost(AdvancedTooltipsConfig config, GatherTooltipComponentsEvent event) {
        ItemStack itemStack;
        int cost;
        if (config.repairCost && (cost = (itemStack = event.itemStack()).m_41610_()) > 0) {
            event.list().add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("Repair cost: " + cost)).m_130940_(ChatFormatting.GRAY));
        }
    }
}

