/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.scripting;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.common.events.RenderGuiEvent;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.StatusOverlayConfig;
import com.zergatul.cheatutils.modules.Module;
import com.zergatul.cheatutils.render.Primitives;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class StatusOverlay
implements Module {
    public static final StatusOverlay instance = new StatusOverlay();
    private static final int TranslateZ = 200;
    private static final Minecraft mc = Minecraft.m_91087_();
    private Runnable script;
    private Map<Align, List<MutableComponent>> texts = new HashMap<Align, List<MutableComponent>>();
    private List<FreeText> freeTexts = new ArrayList<FreeText>();
    private HorizontalAlign hAlign;
    private VerticalAlign vAlign;

    private StatusOverlay() {
        for (Align align : Align.values()) {
            this.texts.put(align, new ArrayList());
        }
        Events.PostRenderGui.add(this::render);
    }

    public void setScript(Runnable script) {
        this.script = script;
    }

    public void addText(MutableComponent message) {
        this.texts.get((Object)Align.get(this.vAlign, this.hAlign)).add(message);
    }

    public void addFreeText(int x, int y, MutableComponent message) {
        this.freeTexts.add(new FreeText(x, y, message));
    }

    public void setHorizontalAlign(HorizontalAlign align) {
        this.hAlign = align;
    }

    public void setVerticalAlign(VerticalAlign align) {
        this.vAlign = align;
    }

    private void render(RenderGuiEvent event) {
        if (StatusOverlay.mc.f_91074_ == null) {
            return;
        }
        StatusOverlayConfig config = ConfigStore.instance.getConfig().statusOverlayConfig;
        if (!config.enabled || this.script == null) {
            return;
        }
        for (Align align : Align.values()) {
            this.texts.get((Object)align).clear();
        }
        this.freeTexts.clear();
        this.hAlign = HorizontalAlign.RIGHT;
        this.vAlign = VerticalAlign.BOTTOM;
        this.script.run();
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Align align : Align.values()) {
            List<MutableComponent> list = this.texts.get((Object)align);
            if (list.isEmpty()) continue;
            for (int i = 0; i < list.size(); ++i) {
                MutableComponent text = list.get(i);
                int width = StatusOverlay.mc.f_91062_.m_92852_((FormattedText)text);
                int x = this.getLeft(align.hAlign, mc.m_91268_().m_85445_(), width);
                VerticalAlign verticalAlign = align.vAlign;
                int n = mc.m_91268_().m_85446_();
                Objects.requireNonNull(StatusOverlay.mc.f_91062_);
                int y = this.getTop(verticalAlign, n, 9, i, list.size());
                Objects.requireNonNull(StatusOverlay.mc.f_91062_);
                Primitives.fill(poseStack, x, y, x + width, y + 9, -1873784752);
                event.getGuiGraphics().m_280430_(StatusOverlay.mc.f_91062_, (Component)text, x, y, 0xFFFFFF);
            }
        }
        for (FreeText text : this.freeTexts) {
            int width = StatusOverlay.mc.f_91062_.m_92852_((FormattedText)text.component);
            int n = text.x;
            int n2 = text.y;
            int n3 = text.x + width;
            int n4 = text.y;
            Objects.requireNonNull(StatusOverlay.mc.f_91062_);
            Primitives.fill(poseStack, n, n2, n3, n4 + 9, -1873784752);
            event.getGuiGraphics().m_280430_(StatusOverlay.mc.f_91062_, (Component)text.component, text.x, text.y, 0xFFFFFF);
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private int getLeft(HorizontalAlign align, int screenWidth, int textWidth) {
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case HorizontalAlign.LEFT -> 2;
            case HorizontalAlign.CENTER -> (screenWidth - textWidth) / 2;
            case HorizontalAlign.RIGHT -> screenWidth - 2 - textWidth;
        };
    }

    private int getTop(VerticalAlign align, int screenHeight, int textHeight, int index, int count) {
        return switch (align) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalAlign.TOP -> 2 + index * textHeight;
            case VerticalAlign.MIDDLE -> (screenHeight - textHeight * count) / 2 + index * textHeight;
            case VerticalAlign.BOTTOM -> screenHeight - 2 - textHeight * (count - index);
        };
    }

    private static enum Align {
        TOP_LEFT(VerticalAlign.TOP, HorizontalAlign.LEFT),
        TOP_CENTER(VerticalAlign.TOP, HorizontalAlign.CENTER),
        TOP_RIGHT(VerticalAlign.TOP, HorizontalAlign.RIGHT),
        MIDDLE_LEFT(VerticalAlign.MIDDLE, HorizontalAlign.LEFT),
        MIDDLE_CENTER(VerticalAlign.MIDDLE, HorizontalAlign.CENTER),
        MIDDLE_RIGHT(VerticalAlign.MIDDLE, HorizontalAlign.RIGHT),
        BOTTOM_LEFT(VerticalAlign.BOTTOM, HorizontalAlign.LEFT),
        BOTTOM_CENTER(VerticalAlign.BOTTOM, HorizontalAlign.CENTER),
        BOTTOM_RIGHT(VerticalAlign.BOTTOM, HorizontalAlign.RIGHT);

        private final VerticalAlign vAlign;
        private final HorizontalAlign hAlign;

        private Align(VerticalAlign vAlign, HorizontalAlign hAlign) {
            this.vAlign = vAlign;
            this.hAlign = hAlign;
        }

        public static Align get(VerticalAlign vAlign, HorizontalAlign hAlign) {
            return switch (vAlign) {
                default -> throw new IncompatibleClassChangeError();
                case VerticalAlign.TOP -> {
                    switch (hAlign) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case LEFT: {
                            yield TOP_LEFT;
                        }
                        case CENTER: {
                            yield TOP_CENTER;
                        }
                        case RIGHT: 
                    }
                    yield TOP_RIGHT;
                }
                case VerticalAlign.MIDDLE -> {
                    switch (hAlign) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case LEFT: {
                            yield MIDDLE_LEFT;
                        }
                        case CENTER: {
                            yield MIDDLE_CENTER;
                        }
                        case RIGHT: 
                    }
                    yield MIDDLE_RIGHT;
                }
                case VerticalAlign.BOTTOM -> {
                    switch (hAlign) {
                        case LEFT: {
                            yield BOTTOM_LEFT;
                        }
                        case CENTER: {
                            yield BOTTOM_CENTER;
                        }
                    }
                    yield BOTTOM_RIGHT;
                }
            };
        }
    }

    public static enum VerticalAlign {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HorizontalAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    private record FreeText(int x, int y, MutableComponent component) {
    }
}

