/*
 * Decompiled with CFR 0.152.
 */
package com.zergatul.cheatutils.modules.hacks;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.zergatul.cheatutils.common.Events;
import com.zergatul.cheatutils.configs.ConfigStore;
import com.zergatul.cheatutils.configs.ServerPluginsConfig;
import com.zergatul.cheatutils.controllers.NetworkPacketsController;
import com.zergatul.cheatutils.modules.Module;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlugins
implements Module {
    public static final ServerPlugins instance = new ServerPlugins();
    private final Minecraft mc = Minecraft.m_91087_();
    private long logInNano;
    private State state;
    private int suggestionId;
    private String[] plugins;
    private State bukkitState;
    private int bukkitSuggestionId;
    private String[] bukkitPlugins;
    private Random random = new Random();
    private Logger logger = LogManager.getLogger(ServerPlugins.class);
    private int delay = 20;
    private int waitResponseDelay = 4;

    private ServerPlugins() {
        Events.ClientPlayerLoggingIn.add(this::onLogIn);
        Events.ClientPlayerLoggingOut.add(this::onLogOut);
        NetworkPacketsController.instance.addServerPacketHandler(this::onServerPacket);
        this.reset();
    }

    public String[] getPlugins() {
        if (this.plugins == null) {
            this.scanPlugins();
            return new String[0];
        }
        return (String[])this.plugins.clone();
    }

    public String[] getBukkitPlugins() {
        if (this.bukkitPlugins == null) {
            this.scanBukkitPlugins();
            return new String[0];
        }
        return (String[])this.bukkitPlugins.clone();
    }

    private void scanPlugins() {
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (this.logInNano == 0L) {
            return;
        }
        if (this.state != State.INIT) {
            return;
        }
        ServerPluginsConfig config = ConfigStore.instance.getConfig().serverPluginsConfig;
        if (System.nanoTime() - this.logInNano < (long)config.waitTicks * 50000000L) {
            return;
        }
        this.state = State.SENT_PACKET;
        this.suggestionId = this.random.nextInt(1000000000);
        NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundCommandSuggestionPacket(this.suggestionId, "/"));
    }

    private void scanBukkitPlugins() {
        if (this.mc.f_91073_ == null) {
            return;
        }
        if (this.logInNano == 0L) {
            return;
        }
        if (this.bukkitState != State.INIT) {
            return;
        }
        ServerPluginsConfig config = ConfigStore.instance.getConfig().serverPluginsConfig;
        if (System.nanoTime() - this.logInNano < (long)config.waitTicks * 50000000L) {
            return;
        }
        this.bukkitState = State.SENT_PACKET;
        this.bukkitSuggestionId = this.random.nextInt(1000000000);
        NetworkPacketsController.instance.sendPacket((Packet<?>)new ServerboundCommandSuggestionPacket(this.bukkitSuggestionId, "bukkit:ver "));
    }

    private void onLogIn(Connection connection) {
        this.logInNano = System.nanoTime();
    }

    private void onLogOut() {
        this.reset();
    }

    private void onServerPacket(NetworkPacketsController.ServerPacketArgs args) {
        Packet<?> packet = args.packet;
        if (packet instanceof ClientboundCommandSuggestionsPacket) {
            Suggestions suggestions;
            ClientboundCommandSuggestionsPacket packet2 = (ClientboundCommandSuggestionsPacket)packet;
            if (this.state == State.SENT_PACKET && this.suggestionId == packet2.m_131854_()) {
                this.state = State.RECEIVED_PACKET;
                suggestions = packet2.m_131857_();
                this.plugins = (String[])suggestions.getList().stream().map(Suggestion::getText).toArray(String[]::new);
                if (ConfigStore.instance.getConfig().serverPluginsConfig.autoPrint) {
                    for (String plugin : this.plugins) {
                        this.mc.m_240442_().m_240494_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(plugin)), false);
                    }
                }
            }
            if (this.bukkitState == State.SENT_PACKET && this.bukkitSuggestionId == packet2.m_131854_()) {
                this.bukkitState = State.RECEIVED_PACKET;
                suggestions = packet2.m_131857_();
                this.bukkitPlugins = (String[])suggestions.getList().stream().map(Suggestion::getText).toArray(String[]::new);
                if (ConfigStore.instance.getConfig().serverPluginsConfig.autoPrint) {
                    for (String plugin : this.bukkitPlugins) {
                        this.mc.m_240442_().m_240494_((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(plugin)), false);
                    }
                }
            }
        }
    }

    private void reset() {
        this.logInNano = 0L;
        this.state = State.INIT;
        this.bukkitState = State.INIT;
        this.plugins = null;
        this.bukkitPlugins = null;
    }

    private static enum State {
        INIT,
        SENT_PACKET,
        RECEIVED_PACKET;

    }
}

